%% Call SD Model
close all
%% Load
clear all
load('Fritz99_Fit_5.mat')
load('Fritz99.mat')
dis_data = 1;

%% Vary Parameters
[beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta,T0,V0] = Theta_func_SD(Theta_s);

% s1 = 0;
% k1 = 0;
% eta = 2;
% w1 = 0;
% w2 = 1*w2;

%% Compute
t1 = dat(:,1);
d1 = dat(:,2);
d2 = dat(:,3);
d3 = dat(:,4);
tf = linspace(0,t1(length(t1)));

Y0 = [T0,0,0,d1(1),0,d3(1),d2(1)];
sol =  ode45(@(t,Y) SD(t,Y,beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta), tf, Y0);   
Y = deval(sol,tf)';
Y1 = Y(:,4);  
Y2 = Y(:,7);  
Y3 = Y(:,6);  

%% Plot Figures
figure(1)
p2 = semilogy(tf,Y1,'r','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t1,d1,30,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18);

figure(2)
p2 = plot(tf,Y2,'r','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t1,d2,30,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Symptom Score','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18);

figure(3)
p2 = plot(tf,Y3,'r','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t1,d3,30,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18);


figure(4)
p2 = semilogy(tf,Y(:,5),'r','Linewidth',1.5);
xlabel('Time (Days)','FontSize',22)
ylabel('Adaptive IR','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18);















