%% Call MCMC TS function
close all
clear all
par_name = {'$b$','$q$','$r$','$t_0$'};
par_label = {'b','q','r','t0'};
coll = {'b','r'};
patch_col = (1/256).*[152, 188, 214;
                      214,152,208];
legg = {'Group 1 Data','Group 2 Data'};

%% Forecast Parameters %%%%%%%%%%
sav = 1;         % Save figures?
t_start_vec = [1,2,3,4];
load_prior = 1;  % Load prior?
M = 1e3;         % Maximum theta vec
tstop = 20*60;      % Time of MCMC simulation
n = 32;          % Histogram refinement
in = 2;          % i = 1: fin_func initial guess, i = 2: default initial guess
bn = 0.1;        % burn

u = 2;           % Fit t0
gen = 0;        % Generate data?
d_end = 0;       % Forecast made at this time
z = 2;           % 1: Normal omega, eta; 2: rescaled
K = 1;           % Number of patients
t_end = 10;      % End time of sampling   
inc = 0.5;       % Sampling interval
sc = 0.3*ones(10,1);
sigma1 = 0.278;    % Training data noise (default = 0.7 for non-scaling, default = 0.278 for scaling)
sigma3 = 0.278;   % MCMC likelihood function noise (default = 0.7 for non-scaling, default = 0.278 for scaling)
dis = 1;        % Display figures?
sd = 0.1*[1,1,1,1];
lt = length(t_start_vec);

for gr = 1:2
G = G_func(gr);    

for i = 1:lt
t_start = t_start_vec(i);
    
%%%%% Generate Data %%%%%%%%%%
if gen == 1 
  
if gr == 1
G = [1,1,1,1];
elseif gr == 2
G = [1,0.5,0.5,0.5];
end

[dmat,dmatn,ti] = gen_data_SD(K,sc,G,sigma1,0,t_end,inc,z);
x = t_start/inc;
dat1 = [ti',dmatn];
dat1(:,1) = ti'-t_start;
dat = dat1;
dat1([x+1:length(dat1)],:) = [];
dat([1:x],:) = [];
ti([1:x]) = [];
dat(:,1) = ti'-t_start;

else
load('Synth_Dataset_Min.mat')
%%%%% Maniuplate Loaded Data %%%%%%%%%%
x = t_start/inc;
dat1 = test_dat_func(gr,test_dat_1,test_dat_2);
dat1(:,1) = ti'-t_start;
dat = dat1;
dat1([x+1:length(dat1)],:) = [];
dat([1:x],:) = [];
ti([1:x]) = [];
dat(:,1) = ti'-t_start;
end


%% MCMC  %%%%%%%%%%%%%%%%%%%
if load_prior == 1
load('Prior_Min.mat')
[X1a, X2a] = samelength(X1,X2);
prior_vec = [X1a;X2a];
else
prior_vec = [];
end
tic
[theta_vec_a,acc_vec,guess,MLE] = MCMC_TS_v2(dat,M,1,sigma3,sd,tstop,ones(4,1),[],prior_vec,[],n,u,t_start,in);
if bn == 0
theta_vec = theta_vec_a;
else
theta_vec = burn(theta_vec_a,bn);
end
toc

%% Plot MCMC Simulations
% figure
% % plot(theta_vec(:,5),'r')
% plot(acc_vec(:,1),'r')

%% Histograms %%%%%%%%%%%%
ss = size(theta_vec,2);
for i = 4
% hold on
% figure(i)
figure
histogram(theta_vec(:,i),'Normalization','probability','Facecolor',char(coll(gr)))
set(gca,'FontSize',27)
xlabel(par_name(i),'FontSize',45)
ylabel('Normalised Frequency','FontSize',30)
box on
if sav == 1
filename1 = ['hist_t0',num2str(t_start)];
saveas(gcf,filename1,'epsc')
savefig(gcf,filename1)
end
% if gr == 2
% legend('Healthy','Comorbid','FontSize',22);
% end
% if sav == 1
% saveas(gcf,char(par_label(i)),'epsc')
% end
end

%% Scatter Plot %%%%%%%%%%%%

% co = ss;
% for i = 1:ss
% for j = 1:ss
%     if i > j
% hold on
% figure(co+1) 
% hold on
% co = co+1;
% scatter(theta_vec(:,j),theta_vec(:,i),7,'filled',char(coll(gr)));
% set(gca,'FontSize',27)
% xlabel(par_name(j),'Fontsize',45)
% ylabel(par_name(i),'Fontsize',45)
% box on
% ylabelvert
% if gr == 2
% legend('Healthy','Comorbid','FontSize',22);
% end
%     end
% end
% end

%% Plot  %%%%%%%%%%%%%%%%%%%

t = linspace(0,t_end+t_start);
Y_vec = MCMC_sim(theta_vec,t);

clear Yint
clear Ydic
clear D

figure
hold on
tn = linspace(-t_start,t_end);
for i = 1:size(Y_vec,1)
Yint(:,i) = interp1(t-theta_vec(i,4),Y_vec(i,:),tn,'linear','extrap');
% Yint(:,i) = interp1(t-theta_vec(i,4),Y_vec(i,:),tn,'linear','extrap');
Ydic(:,i) = interp1(tn,Yint(:,i),dat(:,1));
D(i) = err_func(Ydic(:,i),dat(:,2),4);
end
t = tn;
[me,yl,yu] = shade_func(Yint',95);
alpha = 1;
patch([t fliplr(t)], [yl fliplr(yu)],[1 0 0],'Facecolor',patch_col(gr,:),'FaceAlpha',alpha)
p1 = plot(t,me,'color',char(coll(gr)),'linewidth',1.5);

% for i = 1:size(Y_vec,1)
% p1 = plot(t+t_start-theta_vec(i,4),Y_vec(i,:),'color',char(coll(gr)),'linewidth',1.5);
% end

p2 = scatter(dat1(:,1),dat1(:,2),50,[0,0.6,0],'filled','MarkerEdgeColor','k');
p3 = scatter(dat(:,1),dat(:,2),50,'filled','k');
legend([p1(1),p2,p3],{'Model','Unobserved Past Data','Observed Data'},'FontSize',18);    
xline(0,'k--','linewidth',1.5)
xlim([-t_start -t_start+t_end])
ylim([0 20])
axisfunc()

DIC2 = mean(D) + 0.5*var(D);


if sav == 1
CL = clock;
filename = ['MCMC_TS_gr',num2str(gr),'_t0',num2str(t_start),'_',date,'_',num2str(CL(4)),num2str(CL(5))];
saveas(gcf,filename,'epsc')
savefig(gcf,filename)
save(filename);
end

end
end




