%% Call MCMC TS function
clear 
par_name = {'$b$','$q$','$r$','$S_0$'};
par_label = {'b','q','r','S0'};
coll = {'b','r'};
patch_col = (1/256).*[152, 188, 214;
                      214,152,208];
legg = {'Group 1 Data','Group 2 Data'};

%% Forecast Parameters %%%%%%%%%%

gr = 2;          % group
sav = 1;         % Save figures?
d_end = 0;       % Forecast made at this time
z = 2;           % 1: Normal omega, eta; 2: rescaled
K = 1;           % Number of patients
t_start = 0;     % Start time of sampling   
t_end = 10;      % End time of sampling   
inc = 0.5;       % Sampling interval
sc = 0.3*ones(10,1);
sc = eps*ones(10,1);

sigma1 = 0.278;    % Training data noise (default = 0.7 for non-scaling, default = 0.278 for scaling)
sigma3 = 0.278;   % MCMC likelihood function noise (default = 0.7 for non-scaling, default = 0.278 for scaling)
dis = 1;        % Display figures?
gen = 1;        % Generate data?

%%%%% MCMC Parameter %%%%%%%%%%
sd = 0.1*[1,1,1,1];
M = 5e3;         % Maximum theta vec
tstop = 1e9;    % Time of MCMC simulation
n = 32;          % Histogram refinement

for gr = 1:2
    
if gr == 1
G = [1,1,1,1];
elseif gr == 2
G = [1,0.5,0.5,0.5];
end

[dmat,dmatn,ti] = gen_data_SD(K,sc,G,sigma1,t_start,t_end,inc,z);
dat = [ti',dmatn];


%% MCMC  %%%%%%%%%%%%%%%%%%%
[theta_vec,acc_vec,guess,MLE] = MCMC_TS(dat,M,1,sigma3,sd,tstop,ones(4,1),[],[],[],n);

%% Plot MCMC Simulations
% figure
% % plot(theta_vec(:,5),'r')
% plot(acc_vec(:,2),'r')

%% Histograms %%%%%%%%%%%%
ss = size(theta_vec,2);
for i = 1:ss
hold on
figure(i)
histogram(theta_vec(:,i),'Normalization','probability','Facecolor',char(coll(gr)))
set(gca,'FontSize',27)
xlabel(par_name(i),'FontSize',45)
ylabel('Normalised Frequency','FontSize',30)
box on
if gr == 2
legend('Healthy','Comorbid','FontSize',22);
end
% if sav == 1
% saveas(gcf,char(par_label(i)),'epsc')
% end
end

%% Scatter Plot %%%%%%%%%%%%

co = ss;
for i = 1:ss
for j = 1:ss
    if i > j
hold on
figure(co+1) 
hold on
co = co+1;
scatter(theta_vec(:,j),theta_vec(:,i),7,'filled',char(coll(gr)));
set(gca,'FontSize',27)
xlabel(par_name(j),'Fontsize',45)
ylabel(par_name(i),'Fontsize',45)
box on
ylabelvert
if gr == 2
legend('Healthy','Comorbid','FontSize',22);
end
    end
end
end

%% Plot  %%%%%%%%%%%%%%%%%%%

t = linspace(0,t_end);
Y_vec = MCMC_sim(theta_vec,t);
[me,yl,yu] = shade_func(Y_vec,95);
alpha = 1;
figure(co+gr) 
hold on
patch([t fliplr(t)], [yl fliplr(yu)],[1 0 0],'Facecolor',patch_col(gr,:),'FaceAlpha',alpha)
p1 = plot(t,me,'color',char(coll(gr)),'linewidth',1.5);
p2 = scatter(ti',dmatn,50,'filled','k');
legend([p1,p2],{'Model',char(legg(gr))},'FontSize',18);     
axisfunc()

if sav == 1
CL = clock;
filename = ['MCMC_TS_G',num2str(gr),'_t',num2str(tstop),'_',date,'_',num2str(CL(4)),num2str(CL(5))];
save(filename);
end

end



