%% Call the MCMC SD function, fitting the SD model to the real data 
clear all
load('Fritz99_Fit_5.mat')
par_name = {'$\beta$','$p$','$\nu$','$\mu$','$\omega$','$\eta$'};
par_label = {'beta','p','nu','mu','omega','eta'};
t1 = dat(:,1);
d1 = dat(:,2);
d2 = dat(:,3);
d3 = dat(:,4);

%% Parameteres %%%%%%%%%%%%
sav = 1;
sigma = [0.3,0.7,12];   % Based on average residual of MLE model
guess = theta;
M = 1e9;
sd = 0.1*ones(6,1);
tstop = 60*60;

tic
[theta_vec,acc_vec] = MCMC_SD(dat,M,tstop,guess,Theta,sigma,sd);
toc

%% Plot MCMC Simulations
figure
% plot(theta_vec(:,5),'r')
plot(acc_vec(:,2),'r')

%% Histograms %%%%%%%%%%%%
close all
sav = 0;
for i = 5:6
figure
histogram(theta_vec(:,i),'Normalization','probability')
if i == 5 || i == 6
[~,edges] = histcounts(log10(theta_vec(:,i)));
histogram(theta_vec(:,i),10.^edges,'Normalization','probability');
set(gca, 'XScale', 'log')
end
set(gca,'FontSize',27)
xlabel(par_name(i),'FontSize',45)
ylabel('Normalised Frequency','FontSize',30)
if sav == 1
saveas(gcf,char(par_label(i)),'epsc')
end
% ylim([0 0.15])
end

%% Scatter Plot %%%%%%%%%%%%

for i = 1:size(theta_vec,2)
for j = 1:size(theta_vec,2)
    if i > j
figure
scatter(theta_vec(:,j),theta_vec(:,i),7,'filled','b');
xlabel(par_name(j),'Fontsize',45)
ylabel(par_name(i),'Fontsize',45)
box on
ylabelvert
    end
end
end

Par_ci = theta_ci(theta_vec,95);
Med = median(theta_vec);


%% Scatter Plot %%%%%%%%%%%%

figure
scatter(theta_vec(:,5),theta_vec(:,6),7,'filled','b');
xlabel(par_name(5),'Fontsize',45)
ylabel(par_name(6),'Fontsize',45)
set(gca, 'XScale', 'log')
set(gca, 'YScale', 'log')
box on
ylabelvert


figure
scatter(theta_vec(:,5),theta_vec(:,6)./theta_vec(:,5),7,'filled','b');
xlabel(par_name(5),'Fontsize',45)
ylabel('$\tilde{\eta}$','Fontsize',45)
set(gca, 'XScale', 'log')
box on
ylabelvert


%% Run Simulations and calculate DIC %%%%%%%%%%%%
t = linspace(0,t1(length(t1)));
K = size(theta_vec,1);
V_vec = zeros(K,length(t));
S_vec = zeros(K,length(t));
C_vec = zeros(K,length(t));
D = zeros(K,1);

for i = 1:K
theta = theta_vec(i,:);
Y = ode_func(t,t,theta,Theta,dat);
V_vec(i,:) = Y(:,4);  
S_vec(i,:) = Y(:,7);  
C_vec(i,:) = Y(:,6); 
end

%% Plot MCMC Curves %%%%%%%%%%%%%%%%%%%

figure
hold on
[me,yl,yu] = shade_func(V_vec,95);
patch([t fliplr(t)], [yl fliplr(yu)],[1 0 0],'Facecolor',[152, 188, 214]/256)
p1 = plot(t,me,'b','linewidth',1.5);
p2 = scatter(t1,d1,50,'filled','k');
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)
box on
legend([p2,p1],{'Data',' Model'},'FontSize',18);
set(gca, 'YScale', 'log')
xlim([0 t1(length(t1))])

figure
hold on
[me,yl,yu] = shade_func(S_vec,95);
patch([t fliplr(t)], [yl fliplr(yu)],[1 0 0],'Facecolor',[152, 188, 214]/256)
p1 = plot(t,me,'b','linewidth',1.5);
p2 = scatter(t1,d2,50,'filled','k');
xlabel('Time (Days)','FontSize',22)
ylabel('Symptom Score','FontSize',22)
box on
legend([p2,p1],{'Data',' Model'},'FontSize',18);
xlim([0 t1(length(t1))])

figure
hold on
[me,yl,yu] = shade_func(C_vec,95);
patch([t fliplr(t)], [yl fliplr(yu)],[1 0 0],'Facecolor',[152, 188, 214]/256)
p1 = plot(t,me,'b','linewidth',1.5);
p2 = scatter(t1,d3,50,'filled','k');
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
box on
legend([p2,p1],{'Data',' Model'},'FontSize',18);
xlim([0 t1(length(t1))])

if sav == 1
CL = clock;
filename = ['MCMC_SD_t',num2str(tstop),'_',date,'_',num2str(CL(4)),num2str(CL(5))];
save(filename);
end


%% ODE Function %%%%%%%%%%%%%%%%%%%%%%%%
function Y = ode_func(t,ta,theta,Theta,dat)

d1 = dat(:,2);
d2 = dat(:,3);
d3 = dat(:,4);
[beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta,T0,~] = Theta_func_SD(Theta);
Y0 = [T0,0,0,d1(1),0,d3(1),d2(1)];

beta = theta(1);
p = theta(2);
nu = theta(3);
mu = theta(4);
w2 = theta(5);
eta = theta(6);
sol =  ode45(@(t,Y) SD(t,Y,beta,p,delta,c,kappa,k1,k2,s1,s2,f,r,m,gamma,nu,mu,w1,w2,eta), t, Y0);  
Y = deval(sol,ta)';

end
