%% Compute the classification probability as the number of days worth of observable data is increased 
clear
close all
load('Par_1.mat')
sav = 1;

d_vec = [2:2:40];   % Vector of classifdication days
R = 100;            % Number of repeat experiments
gen = 1;            % Generate data?
% d_vec = 10;        % Classification made at this day
K = 48;             % Number of training data for each group
g_test = 1;         % group to generate test data 
% d_end = 10;         % Forecast made at this time
t_end = 80;         % Length of simulation
inc = 2;            % Time increment of observed data 
sigma1 = 40;        % Training data noise (default = 40)
sigma2 = 0;         % Testing data noise
sigma3 = 40;        % MCMC likelihood function noise (default = 40)   
sc = [1,0.2];       % SD of variable parameters


%%%%% knn Parameters %%%%%%%%%%
m = 1;      % kNN weighting parameter
N = 1e3;    % Number of output simulations
ld = length(d_vec);
prob_vec_SSR = zeros(ld,R);
prob_vec_L = zeros(ld,R);


tstart1 = tic;
for r = 1:R
r    

%% Generate Training Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
if gen == 1
if K ~= 0
train_vec = zeros(K,t_end/inc+1,2);
for g = 1:2
for i = 1:K
[k3,mu3] = par_vec_group(Theta_s,sc,g);
P = gen_data(k3,mu3,Theta_s,sigma1,t_end,inc);
train_vec(i,:,g) = P';
end
end
end
end

%% Generate Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
sc = [eps,eps];
[k3,mu3] = par_vec_group(Theta_s,sc,g_test);
[P,t] = gen_data(k3,mu3,Theta_s,sigma2,t_end,inc);
dat = [t,P];

%% Plot Training and Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
% figure 
% hold on
% p1 = plot(t,train_vec(:,:,1),'b');
% p2 = plot(t,train_vec(:,:,2),'r');
% p3 = scatter(t,dat(:,2),50,'filled','k');
% legend([p1(1),p2(2),p3],{'Group 1 Training Data','Group 2 Training Data','Test Data'},'FontSize',18);  
% xline(d_end,'k--','linewidth',1.5)
% axisfunc

%% kNN Classifier  %%%%%%%%%%%%%%%%%%%%%%%%%%%%
for j = 1:ld
d_end = d_vec(j);
[pr_SSR,pr_L] = classify_knn(dat,train_vec,t,d_end,m,N,max(1,sigma1));
prob_vec_SSR(j,r) = pr_SSR;
prob_vec_L(j,r) =  pr_L;
end

end
toc(tstart1)


%% Plot %%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
hold on
% plot(d_vec,mean(prob_vec_SSR,2),'b','linewidth',1.5)
plot(d_vec,mean(prob_vec_L,2),'r','linewidth',1.5)
plot(d_vec,sum(round(prob_vec_L),2)/R,'b','linewidth',1.5)
xlabel('Days of Observed Data','FontSize',22)
ylabel('Group 1 Classification','FontSize',22)
legend('Mean Probability','Proportion Correct','Fontsize',18)
box on
ylim([0 1])
shg

%% Save %%%%%%%%%%%%%%%%%%%%%%%%%%%%
if sav == 1
CL = clock;
filename = ['Classify_knn_R',num2str(R),'_K',num2str(K),'_',date,'_',num2str(CL(4)),num2str(CL(5))];
save(filename)
end


