 %% Generate synthetic symptom score data from the SD model and fit TS model

close all

tic
sav = 1;        % save?
K = 24;         % Number of patients
d_end = 3;      % End of green shaded region in schematic
GR = 1;         % Green region data group 
z = 2;          % 1: Normal omega, eta; 2: rescaled
t_start = 0;    % Start time of sampling   
t_end = 10;     % End time of sampling   
inc = 0.5;      % Sampling interval
sigma1 = 0.278;    % Noise parameter
sigma3 = 0.278;    % Noise parameter
sc = 0.2*ones(10,1);

%%%%% MCMC Parameters %%%%%%%%%%
sd = 0.1*[1,1,1,1];
M1 = 1e3;         % Maximum theta vec
M2 = 1e3;         % Maximum theta vec
tstop1 = 300;      % Time of MCMC simulation
tstop2 = 300;      % Time of MCMC simulation
n = 32;           % Histogram refinement

for gr = 1:2
    
%%% Generate Training Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%    
G = G_func(gr);
[~,dmatn,ti] = gen_data_SD(K,sc,G,sigma1,t_start,t_end,inc,z);
train_vec = [ti',dmatn];

if gr == 1
X1 = MCMC_prior(train_vec,sigma1,sd,tstop1,M1,n,t_end);
elseif gr == 2
X2 = MCMC_prior(train_vec,sigma1,sd,tstop1,M1,n,t_end);
end

end

%% Generate Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
G = G_func(GR);
sc = eps*ones(10,1);
[~,dmatn,ti] = gen_data_SD(1,sc,G,sigma1,t_start,d_end,inc,z);
test_dat1 = [ti',dmatn];

% X3 = MCMC_prior(test_dat1,sigma1,sd,tstop2,M2,n,d_end);
X3a = MCMC_TS(test_dat1,M2,1,sigma1,sd,tstop2,ones(4,1),[],[X1a;X2a],d_end,n);


%% Plot Parameter Histogram and Scatter
plot_group_MCMC(X1,X2,X3a)

%% Plot Patch Figure
figure
patch_col = [0, 0, 1;
             1,0,0;
             0, 1, 0];  
legg = {'Healthy','Comorbid','New Patient'};
T = t_end;
A = [0.6,0.6,0.6];

for i = 1:3

if i == 1
theta_vec = X1;
elseif i == 2
theta_vec = X2;
elseif i == 3
theta_vec = X3a;
end

if i == 3
T= d_end;
end
t = linspace(0,T);
Y_vec = MCMC_sim(theta_vec,t);
[me,yl,yu] = shade_func(Y_vec,95);
hold on
patch([t fliplr(t)], [yl fliplr(yu)],[1 0 0],'Facecolor',patch_col(i,:),'Facealpha',A(i)) 
end

scatter(test_dat1(:,1),test_dat1(:,2),50,'filled','k');
axisfunc()
shg
legend({'Model: Healthy','Model: Comorbid','Model: New Patient','New Patient Data'},'FontSize',18); 


%% Part 2: Generate test data and make classifications %%%%%%%%%%%%%%%%%%%%%%%%%%
load('Classify_TS_24-Feb-2021_1934.mat')
sav = 1;

Kt = 100;             % Number of test patients
d_vec = [1:0.5:10];
s = 1;              % s = 1: classify using unscaled parameters, s = 2: using log parameters
% sc = 0.3*ones(10,1);
sc2 = 0.2*ones(10,1);
sigma4 = 0;
M3 = 500;         % Maximum theta vec
tstop3 = 60;      % Time of MCMC simulation

[X1a, X2a] = samelength(X1,X2);
ld = length(d_vec);
length_theta = zeros(ld,1);

%%% Generate Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
G = G_func(GR);
[dmat,dmatn,ti] = gen_data_SD(Kt,sc2,G,sigma4,t_start,t_end,inc,z);

%%% Call classify function 
clear prob_vec
for i = 1:Kt
i
parfor j = 1:ld
test_dat = [ti',dmatn(:,i)];
d_end = d_vec(j);
theta_vec = MCMC_TS(test_dat,M3,1,sigma1,sd,tstop3,ones(4,1),[],[X1a;X2a],d_end,n);
length_theta(j) = size(theta_vec,1);
pr_1 = classify_TS(X1,X2,theta_vec,1,n);
pr_2 = classify_TS(X1,X2,theta_vec,2,n);
prob_vec_1(j,i) = pr_1(1);
prob_vec_2(j,i) = pr_2(1);
end
end

%%% Plot Final Results
figure
plot(d_vec,prob_vec_1,'linewidth',1.5)
figure
plot(d_vec,prob_vec_2,'linewidth',1.5)


toc
if sav == 1
CL = clock;
filename = ['Classify_TS_',date,'_',num2str(CL(4)),num2str(CL(5))];
save(filename);
end


% %% Plot Parameter Histogram and Scatter
% plot_group_MCMC(X1,X2,theta_vec)
% pr_1 = classify_TS(X1,X2,theta_vec,1,n)
% pr_2 = classify_TS(X1,X2,theta_vec,2,n)

%% Plot Shaded Figure
shad_vec = [50,50,50];
alpha_vec = [0.8,0.6,0.4];
figure
for ii = 1:3
[me,yl,yu,med] = shade_func(prob_vec_1',shad_vec(ii));
hold on
patch([d_vec fliplr(d_vec)], [yl fliplr(yu)],[1 0 0],'Facecolor','b','FaceAlpha',alpha_vec(ii),'edgecolor','none')
shg
end
plot(d_vec,me,'r','linewidth',1.5);
xlabel('Time Since Infection (Days)','FontSize',26)
ylabel('Group 1 Probability','FontSize',26)
box on
shg


%% Post Processing 

figure
plot(d_vec,100*P,'r','linewidth',1.5);
xlabel('Days of Observed Data','FontSize',26)
ylabel({'Percentage of Patients';'Classified Correctly'},'FontSize',26)
box on
ylim([50 100])
shg


%% 
% XX = [0.5,0.52,0.58,0.65,0.7,0.85,0.86,0.94,0.96,0.98,0.99,0.99,0.99]';
% fake_vec = zeros(length(XX),100);
% 
% for i = 1:100
% for j = 1:13    
% fake_vec(j,i) = min(XX(j) + normrnd(0,0.1),1);
% end
% end
% 
% 
% shad_vec = [50,75,95];
% alpha_vec = [0.8,0.6,0.4];
% figure
% for ii = 1:3
% [me,yl,yu] = shade_func(fake_vec',shad_vec(ii));
% hold on
% patch([d_vec fliplr(d_vec)], [yl fliplr(yu)],[1 0 0],'Facecolor','b','FaceAlpha',alpha_vec(ii),'edgecolor','none')
% shg
% end
% plot(d_vec,me,'r','linewidth',1.5);
% xlabel('Time Since Infection (Days)','FontSize',26)
% ylabel('Group 1 Probability','FontSize',26)
% box on
% shg

% %% Plot Scores
% figure
% hold on
% if gr == 1
% p1 = plot(ti,dmatn,'b','Linewidth',1);
% elseif gr == 2
% p2 = plot(ti,dmatn,'r','Linewidth',1);
% end
% xlabel('Time (Days)','FontSize',22)
% ylabel('Symptom Score','FontSize',22)
% box on 
% % legend([p1(1),p2(1)],{'Healthy','Comorbid'},'FontSize',18); 
% shg
% 
% % end

