%% Compute the classification probability as the number of days worth of observable data is increased 
clear
close all
load('Par_1.mat')
load('MCMC_Group_K48_t60.mat')

sav = 1;            % Save?
pri = 1;          % Use prior?
d_vec = [2:2:40];   % Vector of classifdication days
% d_vec = 10;       % Classification made at this day
s = 2;              % s = 1: classify using unscaled parameters, s = 2: using log parameters
g = 2;              % group to generate data 
d_end = 20;         % Forecast made at this time
t_end = 80;         % Length of simulation
inc = 2;            % Time increment of observed data 
sigma2 = 0;         % Testing data noise
sigma3 = 40;        % MCMC likelihood function noise (default = 40)   
sc = [eps,eps];     % SD of variable parameters
tstop = 10*60;       % Time of forecasting simulation 
M = 10e3;           % Maximum MCMC vector output
n1 = 32;            % Histogram refinement MCMC
n2 = 32;            % Histogram refinement classification

[X1, X2] = samelength(X1,X2);
ld = length(d_vec);
% prob_vec = zeros(ld,4);
length_theta = zeros(ld,1);

%% Generate Test Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
if g == 1
k3 = par_var(Theta_s(8),sc(1));
mu3 = par_var(Theta_s(22),sc(2));

elseif g == 2
k3 = par_var(5e-6,sc(1));
mu3 = par_var(5e-2,sc(2));
end
[P,t] = gen_data(k3,mu3,Theta_s,sigma2,t_end,inc);
dat = [t,P];

%% MCMC Forecast for loop %%%%%%%%%%%%%%%%%%%%%%%%%%%%
tstart1 = tic;
parfor j = 1:ld
d_end = d_vec(j)
sd = 0.1*[1,1,1,1];
t = [0:inc:t_end]';
if pri == 1
theta_vec = MCMC_QP(dat,M,1,sigma3,sd,tstop,ones(4,1),[],[X1;X2],d_end,n1);
elseif pri == 0
theta_vec = MCMC_QP(dat,M,1,sigma3,sd,tstop,ones(4,1),[],[],d_end,n1);
end
length_theta(j) = size(theta_vec,1);
% pr = classify_QP(X1,X2,theta_vec,s,n2);
% prob_vec(j) = pr(1);

% pr = classify_QP(X1,X2,theta_vec,1,32);
% prob_vec_1(j) = pr(1);
% pr = classify_QP(X1,X2,theta_vec,2,32);
% prob_vec_2(j) = pr(1);
% pr = classify_QP(X1,X2,theta_vec,1,64);
% prob_vec_3(j) = pr(1);
% pr = classify_QP(X1,X2,theta_vec,2,64);
% prob_vec_4(j) = pr(1);

end
toc(tstart1)

%% Plot %%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
hold on
plot(d_vec,prob_vec,'linewidth',1.5)
% plot(d_vec,prob_vec_1,'linewidth',1.5)
% plot(d_vec,prob_vec_2,'linewidth',1.5)
% plot(d_vec,prob_vec_3,'linewidth',1.5)
% plot(d_vec,prob_vec_4,'linewidth',1.5)
xlabel('Days of Observed Data','FontSize',22)
ylabel('Group 1 Classification','FontSize',22)
% legend('s=1,n=32','s=2,n=32','s=1,n=64','s=2,n=64','Fontsize',18)
box on
shg

%% Save %%%%%%%%%%%%%%%%%%%%%%%%%%%%
if sav == 1
CL = clock;
filename = ['Classify_QP_tstop',num2str(tstop),'_M',num2str(M),'_',date,'_',num2str(CL(4)),num2str(CL(5))];
save(filename)
end


