%% Perform simulations on a cluster
% 
%%
% This example uses the local (default) cluster profile that is
% pre-configured to the local desktop machine. You can also search for
% other MATLAB(R) Distributed Computing Server(TM) clusters that are
% running on Amazon EC2(R). On the *Home* tab in the *Environment* section,
% select *Parallel* > *Discover Clusters*. To access these clusters, you
% must provide your MathWorks(R) Account login information. For details,
% see <docid:distcomp_ug.f5-16141 Discover Clusters and Use Cluster Profiles>.
%%
% Start parallel pool on your local machine.
parpool;
%%
% Load a sample project containing the G-protein model described in the
% <docid:simbio_ug.bqh3xbo-1 Model of the Yeast Heterotrimeric G Protein Cycle>.
sbioloadproject gprotein;
%%
% To simulate the model in parallel, first create a |SimFunction| object.
% The object provides a function-like interface to simulate models.
%%
% Suppose you want to scan the rate of G-protein inactivation |kGd| and
% see how the model behaves under each value. Define |kGd| as the input of
% the |SimFunction| object. Then define other species and parameters such as
% |Ga|, |RL|, |G| as observables, that is, outputs of the object that you
% can plot and observe. Since there are no doses, pass in an empty array as
% the last input argument.
%%
% Set the |'UseParallel'| option to true to simulate the model using the
% available workers.
f = createSimFunction(m1,{'kGd'},{'Ga','RL','G'},[],'UseParallel',true)
%%
% Sample the values of |kGd| to scan.
 kGdValues = linspace(1e-3, 0.15, 5)';
 %%
 % Simulate the model multiple times using different |kGd| values for 600s.
 sbioplot(f(kGdValues,600));
 %%
 % Shut down the parallel pool.
 delete(gcp('nocreate'));

%% 
% Copyright 2012 The MathWorks, Inc.