%% Run Sobol Sensitivity Analysis 

% Parameter Values
beta = 2e-6;
p = 0.1;
kappa  = 4;
delta = 2;
c = 10;
T0 = 7e9;
V0 = 1;

%% Set Parameter Values
m1.Parameters(1, 1).Value = beta;
m1.Parameters(2, 1).Value = p;
m1.Parameters(3, 1).Value = kappa;
m1.Parameters(4, 1).Value = delta;
m1.Parameters(5, 1).Value = c;
m1.Parameters(6, 1).Value = T0;
m1.Parameters(7, 1).Value = V0;

%% Parameters and Observables
par = {'beta','p','c','kappa','delta','T0','V0'};
obs = 'V';

% Parameter Bounds
sc = 2;
bounds_mat = [(1/sc)*beta, sc*beta;
              (1/sc)*p, sc*p;
              (1/sc)*c, sc*c;
              (1/sc)*kappa, sc*kappa;
              (1/sc)*delta, sc*delta;
              (1/sc)*T0, sc*T0
              (1/sc)*V0, sc*V0];


%% Run Sobol Simulations
tic
sobolV = sbiosobol(m1,par,obs,'Bounds',bounds_mat,'Stoptime',12,'ShowWaitBar',true,'Useparallel',true);
toc

%% Add Observables
tic
sobolObs1 = addobservable(sobolV,'Max V','max(V)');
toc

tic
sobolObs2 = addobservable(sobolObs1,'AUC','trapz(time,V)');
toc

%%
tic
sobolAll = addobservable(sobolObs2,'Duration','dur_inf(V,time,1e3)');
toc

sobolScalar = removeobservable(sobolAll,'V');

%% Plot Time Dependent Data
plotData(sobolV);
set(gca, 'YScale', 'log')
shg

%% Plot Scalar Data
h = plotData(sobolScalar);
h.Position(:) = [100 100 1280 500];
shg

%% Plot Time Dependent Sobol Indicies 
h = plot(sobolV);
h.Position(:) = [100 100 1280 800];

bar(sobolV)
shg
% set(gca,'YTickLabel',{'$p$','$\beta$'},'fontsize',26,'TickLabelInterpreter','latex')
% title('$V$','fontsize',26,'interpreter','latex')

%% Plot Scalar Sobol Indicies
h = bar(sobolScalar);
h.Position(:) = [100 100 1280 400];
shg



