%% Run Sobol Sensitivity Analysis 

% a = 1: Supressed
% a = 4: Healthy
a = 4;
sc = 2;
sav = 1;
Samp = 500;
load('m1.mat')
load('Pooled_MLE.mat')

%% Parameter Values

if a == 1
% beta = 1.10e-7;
% p = 0.560;
% c = 10;
% kappa  = 4;
% delta = 2;
% s = 0.323;
% tau = 0.934;
% f = 0;
% r = 0;
% m = 0;
% gamma = 0;
% k = 0;
% T0 = 7e9;
% V0 = 1.77;

elseif a == 4
% beta = 1.27e-7;
% p = 0.0944;
% delta = 2;
% c = 10;
% kappa  = 4;
% s = 0.033;
% tau = 1.46;
% f = 2.44e-6;
% r = 0.23;
% m = 1;
% gamma = 0.0058;
% k = 2.05;
% T0 = 7e9;
% V0 = 4090;
[beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k,T0,V0] = Theta_func_new(Theta_s);
end

%% Set Parameter Values
m1.Parameters(1, 1).Value = beta;
m1.Parameters(2, 1).Value = p;
m1.Parameters(3, 1).Value = kappa;
m1.Parameters(4, 1).Value = delta;
m1.Parameters(5, 1).Value = c;
m1.Parameters(6, 1).Value = T0;
m1.Parameters(7, 1).Value = V0;
m1.Parameters(8, 1).Value = s;
m1.Parameters(9, 1).Value = tau;
m1.Parameters(12, 1).Value = f;
m1.Parameters(13, 1).Value = r;
m1.Parameters(14, 1).Value = m;
m1.Parameters(15, 1).Value = gamma;
m1.Parameters(16, 1).Value = k;

%% Parameters and Observables


if a == 1
par = {'beta','p','delta','c','kappa','s','tau','T0','V0'};
pmin=(1/sc)*[beta,p,delta,c,kappa,s,tau,T0,V0]; 
pmax=sc*[beta,p,delta,c,kappa,s,tau,T0,V0]; 
elseif a == 4
par = {'beta','p','delta','c','kappa','s','tau','f','r','m','gamma','k','T0','V0'};    
pmin=(1/sc)*[beta,p,delta,c,kappa,s,tau,f,r,m,gamma,k,T0,V0]; 
pmax=sc*[beta,p,delta,c,kappa,s,tau,f,r,m,gamma,k,T0,V0]; 
end
   
obs = {'V','Frac'};
bounds_mat = [pmin',pmax'];

%% Run Sobol Simulations
tic
sobolV = sbiosobol(m1,par,obs,'Bounds',bounds_mat,'Stoptime',20,'ShowWaitBar',true,'Useparallel',true,'NumberSamples',Samp);
toc

%% Add Observables

tic
sobolObs1 = addobservable(sobolV,'Max V','max(V)');
toc

tic
sobolObs2 = addobservable(sobolObs1,'Time Max','time_max(V,time)');
toc

tic
sobolObs3 = addobservable(sobolObs2,'AUC','trapz(time,V)');
toc

tic
sobolObs4 = addobservable(sobolObs3,'Duration','dur_inf(V,time,6.9e3)');
toc

tic
sobolAll = addobservable(sobolObs4,'Frac Dead Cells','Frac(length(time))');
toc

sobolScalar1 = removeobservable(sobolAll,'V');
sobolScalar = removeobservable(sobolScalar1,'Frac');

if sav == 1
filename = ['Sobol_sc',num2str(sc),'_Samp',num2str(Samp)];
save(filename)
end

% %% Plot Time Dependent Data
% plotData(sobolV);
% set(gca, 'YScale', 'log')
% shg
% 
% %% Plot Scalar Data
% h = plotData(sobolScalar);
% h.Position(:) = [100 100 1280 500]; 
% shg
% 
% %% Plot Time Dependent Sobol Indicies 
% h = plot(sobolV);
% h.Position(:) = [100 100 1280 800];
% 
% bar(sobolV)
% 
% h = plot(sobolT);
% h.Position(:) = [100 100 1280 800];
% 
% bar(sobolT)
% shg


%% Plot Scalar Sobol Indicies
% h = bar(sobolScalar);
% h.Position(:) = [100 100 1280 400];
% shg
% 


