%% Practical Identifiability Analysis of the TV model

clc
close all
clear all

sav = 1;
par_name = {'$\beta$','$p$','$c$','$V_0$'};
label1 = {'beta','p','c','V0'};
tstart = tic;

for z = 1:4
D = ['z = ',num2str(z)];
disp(D)

%% Generate Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('TV_MLE.mat')
Theta = Theta_s;
t_end = 12;
t = [0:1:t_end]';
tf = linspace(0,t_end);
sol =  ode45(@(t,Y) TV(t,Y,Theta_s(1),Theta_s(2),Theta_s(3)), tf, [Theta_s(4), Theta_s(5)]);     
Y1 = deval(sol,t)';
Y = Y1(:,2);
dat = [t,Y];

%%
inc = 0.1;
base = Theta_s(func1(z));

if z == 1
A1 = 1;
A2 = -3;
elseif z == 2 
A1 = 3;
A2 = -1;
elseif z == 3
A1 = 2;
A2 = -1;
elseif z == 4
A1 = 1;
A2 = -1;
end

par_vec_1 = base*10.^[0:inc:A1]';
par_vec_2 = base*10.^[0:-inc:A2]';
l1 = length(par_vec_1);
l2 = length(par_vec_2);
par_vec = [par_vec_1;par_vec_2];
err_vec = zeros(l1+l2,1);

for i = 1:l1+l2
    disp(i)
if i == l1+1    
    Theta = Theta_s;
end
j = func1(z);
Theta(j) = par_vec(i);
[~,Theta_s0,~,~,~,~,err,~,~,~] = fit_TV(dat,Theta,1+z,0,0);
% if i == 14 || i == 15
% figure
% [~,Theta_s0,~,~,~,~,err,~,~,~] = fit_TV(dat,Theta,1+z,1,1);
% end
disp(err)
err_vec(i) = err;
if z == 2 || z == 3 || z == 4
Theta = Theta_s0;
end
end
[P,E] = sort_func(par_vec,err_vec,l1);

%% Plot Results %%%%%%%%%%%%%%%%%%%%%
figure
% scatter(P(:,z),E(:,z),50,'r','filled')
% hold on
plot(P,E,'r','linewidth',1.5);
% plot(P(:,z)/base,E(:,z),'r','linewidth',1.5);
yline(4.695,'k--','linewidth',1.5);
set(gca,'xscale','log')
xlabel(par_name(z),'FontSize',26)
ylabel('$\chi^2_{\textrm{PL}}$','FontSize',26)
xlim([P(1) P(length(P))])
ylim([0 20])
box on
shg

if sav == 1
filename = ['PL_TV_',char(label1(z))];
saveas(gcf,filename,'epsc')
savefig(gcf,filename)
% shg
end

if sav == 1
filename2 = ['PL_TV_',char(label1(z))];
save(filename2)
end


end


toc(tstart)

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function j = func1(z)

if z == 1
j = 1;
elseif z == 2
j = 2;
elseif z == 3
j = 3;
elseif z == 4
j = 5;
end

end

