%% Practical Identifiability Analysis of the TEIV model

clc
close all
clear all

sav = 1;
par_name = {'$\beta$','$p$','$\delta$','$c$','$V_0$'};
label1 = {'beta','p','delta','c','V0'};
tstart = tic;

for z = 4
D = ['z = ',num2str(z)];
disp(D)

%% Generate Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('TEIV_MLE.mat')
Theta = Theta_s;
t_end = 12;
t = [0:1:t_end]';
tf = linspace(0,t_end);
sol = ode45(@(t,Y) TEIV(t,Y,Theta_s(1),Theta_s(3),Theta_s(2),Theta_s(4),Theta_s(5)),tf, [Theta_s(6), 0, 0, Theta_s(7)]);
Y1 = deval(sol,t)';
Y = Y1(:,4);
dat = [t,Y];

%%
inc = 0.2;
base = Theta_s(func1(z));

if z == 1
A1 = 2;
A2 = -1;
elseif z == 2 
A1 = 2;
A2 = -2;
elseif z == 3
A1 = 2;
A2 = -2;
elseif z == 4
A1 = 1;
A2 = -1;
elseif z == 5
A1 = 1;
A2 = -1;
end

par_vec_1 = base*10.^[0:inc:A1]';
par_vec_2 = base*10.^[0:-inc:A2]';
l1 = length(par_vec_1);
l2 = length(par_vec_2);
par_vec = [par_vec_1;par_vec_2];
err_vec = zeros(l1+l2,1);

for i = 1:l1+l2
    disp(i)
if i == l1+1    
    Theta = Theta_s;
end
j = func1(z);
Theta(j) = par_vec(i);
[~,Theta_s0,~,~,~,~,err,~,~,~] = fit_TEIV(dat,Theta,1+z,0,0);
if i == 2 || i == 3
figure
[~,Theta_s0,~,~,~,~,err,~,~,~] = fit_TEIV(dat,Theta,1+z,1,1);
end
disp(err)
err_vec(i) = err;
if z ~= 10
Theta = Theta_s0;
end
end
[P,E] = sort_func(par_vec,err_vec,l1);

%% Plot Results %%%%%%%%%%%%%%%%%%%%%
figure
plot(P,E,'r','linewidth',1.5);
% plot(P(:,z)/base,E(:,z),'r','linewidth',1.5);
yline(5.861,'k--','linewidth',1.5);
set(gca,'xscale','log')
xlabel(par_name(z),'FontSize',26)
ylabel('$\chi^2_{\textrm{PL}}$','FontSize',26)
xlim([P(1) P(length(P))])
ylim([0 20])
box on
shg

if sav == 1
filename = ['PL_TEIV_',char(label1(z))];
saveas(gcf,filename,'epsc')
savefig(gcf,filename)
% shg
end

if sav == 1
filename2 = ['PL_TEIV_',char(label1(z))];
save(filename2)
end


end


toc(tstart)

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function j = func1(z)

if z == 1
j = 1;
elseif z == 2
j = 2;
elseif z == 3
j = 3;
elseif z == 4
j = 4;
elseif z == 5
j = 7;
end

end

