%% Practical Identifiability Analysis of the IR model

close all
sav = 1;
plott = 1;
par_name = {'$\beta$','$p$','$V_0$','$s$', '$\tau$', '$f$', '$r$','$k$'};
label1 = {'beta','p','V0','s', 'tau', 'f', 'r','k'};

tstart = tic;
for b = 1:7
D1 = ['b = ',num2str(b)];
disp(D1)

clear P E

for z = 1:8
D = ['z = ',num2str(z)];
disp(D)

%% Set-Up %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('Pooled_MLE.mat')
Theta = Theta_s;
sigma = zeros(4,1);
M = 1;
t_end = 12;
% [V_vec, Frac_vec, AB_vec, IFN_vec] = gen_data_all(sigma,t_end,M);

% Generate synthetic data 
[Vc, Fc, Xc] = gen_data_IR(sigma,t_end,1,Theta_s);
Theta_s(8) = 0;
[Vs, Fs] = gen_data_IR(sigma,t_end,1,Theta_s);
dat = [Vc', Fc', Xc', Vs', Fs'];
load('Pooled_MLE.mat')

%%
sigma = [0.3,0.05,0.1,0.2];
inc = 0.1;
base = Theta_s(get_Theta(z));
par_vec_1 = base*10.^[0:inc:1]';
par_vec_2 = base*10.^[0:-inc:-1]';
l1 = length(par_vec_1);
l2 = length(par_vec_2);
par_vec = [par_vec_1;par_vec_2];
err_vec = zeros(l1+l2,1);

% 
for i = 1:l1+l2
    disp(i)
if i == l1+1    
    Theta = Theta_s;
end
j = get_Theta(z);
Theta(j) = par_vec(i);
[err,Theta_s0] = fit_IR_prac_id(dat,Theta,sigma,1+z,b);
% disp(err)
err_vec(i) = err;
Theta = Theta_s0;
end
[P(:,z),E(:,z)] = sort_func(par_vec,err_vec,l1);

%% Plot Results %%%%%%%%%%%%%%%%%%%%%

if plott == 1
figure
% scatter(P(:,z),E(:,z),50,'r','filled')
% hold on
plot(P(:,z),E(:,z),'r','linewidth',1.5);
yline(9.27,'k--','linewidth',1.5);
if z ~= 5
set(gca,'xscale','log')
end
set(gca,'FontSize',27)
xlabel(par_name(z),'FontSize',45)
ylabel('$\chi^2_{\textrm{PL}}$','FontSize',30)
xlim([P(1,z) P(size(P,1),z)])
ylim([0 100])
box on
shg

if sav == 1
filename = ['IR_PL_',char(label1(z)),'_b',num2str(b)];
saveas(gcf,filename,'epsc')
savefig(gcf,filename)
% shg
end

end

end

if sav == 1
filename2 = ['IR_PL_b',num2str(b)];
save(filename2)
end

end
toc(tstart)
