function [D,Dm] = plot_forecast_MCMC(theta_vec,train_vec,dat,Y_vec,d_end,dis,Theta_s,u,alpha)
 
if u == 1
T0 = 7e9;
elseif u == 2
T0 = 7e9;
kappa = 4; 
elseif u == 3
[beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k,T0,V0] = Theta_func_new(Theta_s);
end
 
%%% Compute Simulations and Forecast Error %%%%%%%%%%%%%%%%%%%%%%%%%%%%
S = size(theta_vec,1);
D = zeros(S,1);
[t1,d1,t2,d2] = split_data(dat,d_end);
t1 = [0;t1];
if isempty(t1)
t2a = [0;t2];
st = 1;
else
t2a = [t1(length(t1));t2];  
st = 2;
end
Y_vec2 = zeros(S,length(t2a));
t = dat(:,1);
for i = 1:S
theta = theta_vec(i,:);
if d_end == 0
Y = ode_func(t2a,theta,u);    
else    
Y0 =  Q_func(t1,theta,d1,u);
Y = ode_func2(t2a,theta,Y0,u);
% Y = ode_func2(t2a,theta,[Y0(1),Y0(2)]);
end
Y_vec2(i,:) = Y;
D(i) = err_func(Y(st:length(Y)),d2,0.3,5);
end
 
%% Error of Mean Paramter Forecast %%%%%%%%%%%%%%%%%%%%%%%%%%%%
theta = mean(theta_vec);
if d_end == 0
Ym = ode_func(t2a,theta,u);    
else    
Y0 =  Q_func(t1,theta,d1,u);
Ym = ode_func2(t2a,theta,Y0,u);
end
Dm = err_func(Ym(st:length(Ym)),d2,0.3,5);
 
 
if dis == 1
%%% Plot Training Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
hold on
if ~isempty(train_vec)
p1 = plot(t,train_vec,'color',[0, 135, 0]/256,'linewidth',0.5);
end
axisfunc()
 
%%% Plot Model Calibration Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%
me = shade_func(Y_vec,95);
me = me([1:length(t1)]);
plot(t1,me,'b--','linewidth',1.5);
 
%%%% Plot Model Forecast %%%%%%%%%%%%%%%
[me,yl,yu] = shade_func(Y_vec2,100);
patch([t2a' fliplr(t2a')], [yl fliplr(yu)],[1 0 0],'Facecolor',[152, 188, 214]/256,'FaceAlpha',alpha)
p4 = plot(t2a,me,'b','linewidth',1.5);
 
%%%% Plot Test Data %%%%%%%%%%%%%%%
p2 = scatter(t1([2:length(t1)]),d1,50,'filled','k');
p3 = scatter(t2,d2,50,'filled','m');
if d_end ~= 0
xline(d_end,'k--','linewidth',1.5)
end
if d_end == 0
legend([p1(1),p3,p4],{'Training Data','Future Test Data','Forecast'},'FontSize',18);     
else
if ~isempty(train_vec)    
legend([p1(1),p2,p3,p4],{'Training Data','Observed Test Data','Future Test Data','Forecast'},'FontSize',18);    
else
legend([p2,p3,p4],{'Observed Test Data','Future Test Data','Forecast'},'FontSize',18);    
end
end
set(gca, 'YScale', 'log')
shg
end

%%%% Plot Mean Model Forecast %%%%%%%%%%%%%%%
% p5 = plot(t2a,Ym,'k--','linewidth',1.5); 
 
function Y = ode_func(t,theta,u)  
if u == 1    
sol =  ode45(@(t,Y) TV(t,Y,theta(1),theta(2),theta(3)), t, [T0, theta(4)]);     
Y1 = deval(sol,t)';
Y = Y1(:,2);
elseif u == 2
sol = ode45(@(t,Y) TEIV(t,Y,theta(1),theta(3),theta(2),theta(4),kappa),t, [T0, 0, 0, theta(5)]);
Y1 = deval(sol,t)';
Y = Y1(:,4);    
elseif u == 3
sol = ode45(@(t,Y) IR_new(t,Y,theta(1),theta(2),delta,c,kappa,theta(3),theta(4),theta(5),theta(6),m,gamma,theta(7)), t, [T0, 0, 0, 0, theta(8), 0, 0]);
Y1 = deval(sol,t)';
Y = Y1(:,5);
end
end
 
 
function Y = ode_func2(t,theta,Y0,u)
if u == 1    
sol =  ode45(@(t,Y) TV(t,Y,theta(1),theta(2),theta(3)), t, Y0);     
Y1 = deval(sol,t)';
Y = Y1(:,2);
elseif u == 2
sol = ode45(@(t,Y) TEIV(t,Y,theta(1),theta(3),theta(2),theta(4),kappa),t, Y0);
Y1 = deval(sol,t)';
Y = Y1(:,4);    
elseif u == 3
sol = ode45(@(t,Y) IR_new(t,Y,theta(1),theta(2),delta,c,kappa,theta(3),theta(4),theta(5),theta(6),m,gamma,theta(7)), t, Y0);
Y1 = deval(sol,t)';
Y = Y1(:,5);
end
end
 
 
function Y0 = Q_func(t,theta,d1,u)
 
if u == 1  
sol =  ode45(@(t,Y) TV(t,Y,theta(1),theta(2),theta(3)), t, [T0, theta(4)]);     
Y1 = deval(sol,t)';
l = size(Y1,1);
Y0 = Y1(l,:);
Y0(2) = d1(length(d1));
 
elseif u == 2
sol = ode45(@(t,Y) TEIV(t,Y,theta(1),theta(3),theta(2),theta(4),kappa),t, [T0, 0, 0, theta(5)]);
Y1 = deval(sol,t)';
l = size(Y1,1);
Y0 = Y1(l,:);
Y0(4) = d1(length(d1));
 
elseif u == 3
sol = ode45(@(t,Y) IR_new(t,Y,theta(1),theta(2),delta,c,kappa,theta(3),theta(4),theta(5),theta(6),m,gamma,theta(7)), t, [T0, 0, 0, 0, theta(8), 0, 0]);
Y1 = deval(sol,t)';
l = size(Y1,1);
Y0 = Y1(l,:);
Y0(5) = d1(length(d1));
end
end
 
end
