function [V] = gen_data_TEIV(sigma,t_end,M,Theta)

load('TEIV_MLE_comp_mice.mat')

beta = Theta(1);
p = Theta(2);
delta = Theta(3);
c = Theta(4);
kappa = Theta(5);
T0 = Theta(6);
V0 = Theta(7);
Y0 = [T0,0,0,V0];

t_fine = linspace(0,t_end);
sol =  ode45(@(t,Y) TEIV(t,Y,beta,delta,p,c,kappa), t_fine, Y0); 
t_dat = [1:t_end];
lt = length(t_dat);
Y_dat = deval(sol,t_dat);
V = zeros(M,lt);

for i = 1:M
    noise_vec_1 = normrnd(0,sigma,lt,1)';
    V(i,:) = 10.^(noise_vec_1).*Y_dat(4,:); 
end

end
