function [V_vec,Frac_vec,AB_vec,IFN_vec] = gen_data_IR(sigma,t_end,M,Theta_s)

t_fine = linspace(0,t_end);
[beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k,T0,V0] = Theta_func_new(Theta_s);
Y0 = [T0,0,0,0,V0,0,0];

sol =  ode45(@(t,Y) IR_new(t,Y,beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k), t_fine, Y0); 
t_dat = [1:t_end];
lt = length(t_dat);
Y_dat = deval(sol,t_dat);
V_vec = zeros(M,lt);
Frac_vec = zeros(M,lt);
AB_vec = zeros(M,lt);
IFN_vec = zeros(M,lt);

for i = 1:M
    noise_vec_1 = normrnd(0,sigma(1),lt,1)';
    noise_vec_2 = normrnd(0,sigma(2),lt,1)';
    noise_vec_3 = normrnd(0,sigma(3),lt,1)';
    noise_vec_4 = normrnd(0,sigma(4),lt,1)';
    V_vec(i,:) = 10.^(noise_vec_1).*Y_dat(5,:); 
    Frac_vec(i,:) = max(noise_vec_2 + Y_dat(4,:)/T0,0); 
    AB_vec(i,:) = 10.^(noise_vec_3).*Y_dat(7,:); 
    IFN_vec(i,:) = 10.^(noise_vec_4).*Y_dat(6,:); 
end

end
