
function [theta,Theta_s,Y,ti,Yf,tf,err,AIC,res,L] = fit_TV(dat,Theta,q,dis,dis_data,leg)

ti = dat(:,1);
d1 = dat(:,2);
tf = linspace(0,ti(length(ti)));

beta = Theta(1);
p = Theta(2);
c = Theta(3);
T0 = Theta(4);
V0 = Theta(5);

beta_0 = beta;
c_0 = c;
V0_0 = V0;
p_0 = p;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if q == 1
theta_0 = [beta_0, p_0, c_0, V0_0];
elseif q == 2
theta_0 = [p_0, c_0, V0_0];
elseif q == 3
theta_0 = [beta_0, c_0, V0_0];
elseif q == 4
theta_0 = [beta_0, p_0, V0_0];
elseif q == 5
theta_0 = [beta_0, p_0, c_0];
end

options = optimset('MaxFunEvals',1e5,'MaxIter',1e4,'TolFun',1e-6,'TolX',1e-6);
theta = fminsearch(@(theta) fit_err_func(theta),theta_0,options);
theta = abs(theta);

if q == 1
beta = theta(1);
p = theta(2);
c = theta(3);
V0 = theta(4);
    
elseif q == 2
p = theta(1);
c = theta(2);
V0 = theta(3);    

elseif q == 3
beta = theta(1);
c = theta(2);
V0 = theta(3);

elseif q == 4
beta = theta(1);
p = theta(2);
V0 = theta(3); 

elseif q == 5
beta = theta(1);
p = theta(2);
c = theta(3);
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% if q == 1
% % Fit beta, p, c, V0
% 
% theta_0 = [beta_0, p_0, c_0, V0_0];
% options = optimset('MaxFunEvals',1e5,'MaxIter',1e4);
% % theta = fminsearch(@(theta) odefit_1(theta),theta_0,options);
% theta = fminsearch(@(theta) fit_err_func(theta),theta_0,options);
% theta = abs(theta);
% beta = theta(1);
% p = theta(2);
% c = theta(3);
% V0 = theta(4);
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% elseif q == 2
% % Fix beta - fit p, c, V0 
% 
% theta_0 = [p_0, c_0, V0_0];
% options = optimset('MaxFunEvals',1e5,'MaxIter',1e4);
% theta = fminsearch(@(theta) fit_err_func(theta),theta_0,options);
% theta = abs(theta);
% p = theta(1);
% c = theta(2);
% V0 = theta(3);
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% elseif q == 3
% % Fix p - fit beta, c, V0 
% 
% theta_0 = [beta_0, c_0, V0_0];
% options = optimset('MaxFunEvals',1e5,'MaxIter',1e4);
% theta = fminsearch(@(theta) fit_err_func(theta),theta_0,options);
% theta = abs(theta);
% beta = theta(1);
% c = theta(2);
% V0 = theta(3);
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% elseif q == 4
% % Fix c - fit beta, p, V0 
% 
% theta_0 = [beta_0, p_0, V0_0];
% options = optimset('MaxFunEvals',1e5,'MaxIter',1e4);
% theta = fminsearch(@(theta) fit_err_func(theta),theta_0,options);
% theta = abs(theta);
% beta = theta(1);
% p = theta(2);
% V0 = theta(3);
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% elseif q == 5
% % Fix V0 - fit beta, p, c 
% 
% theta_0 = [beta_0, p_0, c_0];
% options = optimset('MaxFunEvals',1e5,'MaxIter',1e4);
% theta = fminsearch(@(theta) fit_err_func(theta),theta_0,options);
% theta = abs(theta);
% beta = theta(1);
% p = theta(2);
% c = theta(3);
% 
% end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[err,res,L,AIC] = fit_err_func(theta);
Theta_s = [beta,p,c,T0,V0];
Yf = Vi_func(tf);
Y = Vi_func(ti);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if dis == 1
% p2 = semilogy(tf,Yf(:,2),'b','Linewidth',1.5);
p2 = semilogy(tf,Yf(:,2),'Linewidth',1.5);

if  dis_data == 1
    hold on
    p1 = scatter(ti,d1,50,'k','filled');
    box on 
end

xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)
xlim([0 ti(length(ti))])
if dis_data == 1 && leg == 1
legend([p1 p2],{'Data','TV Model'},'FontSize',18);
end
set(gca, 'YScale', 'log')
ylim([1e2 1e6])
shg

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% function err = odefit_1(theta)
% theta = abs(theta);
% beta = theta(1);
% p = theta(2);
% c = theta(3);
% V0 = theta(4);
% err = fit_err_func();
% end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [err,res,L,AIC] = fit_err_func(theta)
    
theta = abs(theta);
    
if q == 1
beta = theta(1);
p = theta(2);
c = theta(3);
V0 = theta(4);
    
elseif q == 2
p = theta(1);
c = theta(2);
V0 = theta(3);    

elseif q == 3
beta = theta(1);
c = theta(2);
V0 = theta(3);

elseif q == 4
beta = theta(1);
p = theta(2);
V0 = theta(3); 

elseif q == 5
beta = theta(1);
p = theta(2);
c = theta(3);
    
end


Y = Vi_func(ti);
Vi = Y(:,2);
[err,res] = err_func(d1,Vi,0.3,5);
[~,~,L] = Likelihood(d1,Vi,0.3,2);
pm = length(theta_0);
nd = length(ti);
AIC = nd*log(err/nd) + 2*(pm+1) + (2*(pm+1)*(pm+2))/(nd - pm);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function Y = Vi_func(t)
sol = ode45(@(t,Y) TV(t,Y,beta,p,c),tf, [T0,V0]);
Y = deval(sol,t)';
end

function dYdt = TV(t,Y,beta,p,c)
dYdt = zeros(2,1);
dYdt(1) = -beta*Y(1)*Y(2);
dYdt(2) = p*beta*Y(1)*Y(2) - c*Y(2);
end



end
