
function [theta,Y,t,Yf,tf,err,res,st,tim] = fit_TIV(dat,Theta,Y0,f,dis,dis_data,v,s)

ti = dat(:,1);
d1 = dat(:,2); 

beta = abs(Theta(1));
delta = abs(Theta(2));
p = abs(Theta(3));
c = abs(Theta(4));

beta_0 = beta;
delta_0 = delta;
p_0 = p;
c_0 = c;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit beta, delta, p, c

if s == 1
theta_0 = [beta_0, delta_0, p_0, c_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic;
if v == 1
theta = fminsearch(@(theta) odefit_1(theta,Y0,ti,f),theta_0,options);
elseif v == 2
theta = fmincon(@(theta) odefit_1(theta,Y0,ti,f), theta_0, [],[],[],[],[0,0,0,0],[1e-4,10,0.5,100],[],options);
end

beta = abs(theta(1));
delta = abs(theta(2));
p = abs(theta(3));
c = abs(theta(4));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit beta, delta, p

elseif s == 2
theta_0 = [beta_0, delta_0, p_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic;
if v == 1
theta = fminsearch(@(theta) odefit_2(theta,c,Y0,ti,f),theta_0,options);
elseif v == 2
theta = fmincon(@(theta) odefit_2(theta,c,Y0,ti,f), theta_0, [],[],[],[],[0,0,0],[1e-4,10,0.5],[],options);
end

beta = abs(theta(1));
delta = abs(theta(2));
p = abs(theta(3));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit beta, p, c

elseif s == 3
theta_0 = [beta_0, delta_0, c_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic;
if v == 1
theta = fminsearch(@(theta) odefit_3(theta,delta,Y0,ti,f),theta_0,options);
elseif v == 2
theta = fmincon(@(theta) odefit_3(theta,delta,Y0,ti,f), theta_0, [],[],[],[],[0,0,0],[1e-4,0.5,100],[],options);
end

beta = abs(theta(1));
p = abs(theta(2));
c = abs(theta(3));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit beta, p

elseif s == 4
theta_0 = [beta_0, p_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic;
if v == 1
theta = fminsearch(@(theta) odefit_4(theta,delta,c,Y0,ti,f),theta_0,options);
elseif v == 2
theta = fmincon(@(theta) odefit_4(theta,delta,c,Y0,ti,f), theta_0, [],[],[],[],[0,0],[1e-4,0.5],[],options);
end

beta = abs(theta(1));
p = abs(theta(2));

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

tim = toc;
if tim > 3
    st = 1;
else
    st = 0;
end
theta = abs(theta);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Solve and plot best fit model

tj = [0; ti];
[t,Y] = ode45(@(t,Y) TIV(t,Y,beta,delta,p,c), tj, Y0);
C = Y(:,3);
[err,res] = err_func(d1,C([2:length(C)]),f);

[tf,Yf] = ode45(@(t,Y) TIV(t,Y,beta,delta,p,c), linspace(0,ti(length(ti))), Y0);

if dis == 1
p2 = semilogy(tf,Yf(:,3),'b','Linewidth',1.5);

if  dis_data == 1
    hold on
    p1 = scatter(ti,d1,30,'k','filled');
    box on 
end

xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer (TCID50/mL)','FontSize',22)
% xlim([ti(1) ti(length(ti))])
if dis_data == 1
legend([p1 p2],{'Data','TIV Model'},'FontSize',18);
end
shg

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_1(theta,Y0,ti,f)
beta = abs(theta(1));
delta = abs(theta(2));
p = abs(theta(3));
c = abs(theta(4));
tj = [0; ti];
[t,Y] = ode45(@(t,Y) TIV(t,Y,beta,delta,p,c), tj, Y0);
C = Y(:,3);
[err,res] = err_func(d1,C([2:length(C)]),f);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_2(theta,c,Y0,ti,f)
beta = abs(theta(1));
delta = abs(theta(2));
p = abs(theta(3));
tj = [0; ti];
[t,Y] = ode45(@(t,Y) TIV(t,Y,beta,delta,p,c), tj, Y0);
C = Y(:,3);
[err,res] = err_func(d1,C([2:length(C)]),f);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_3(theta,delta,Y0,ti,f)
beta = abs(theta(1));
p = abs(theta(2));
c = abs(theta(3));
tj = [0; ti];
[t,Y] = ode45(@(t,Y) TIV(t,Y,beta,delta,p,c), tj, Y0);
C = Y(:,3);
[err,res] = err_func(d1,C([2:length(C)]),f);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_4(theta,delta,c,Y0,ti,f)
beta = abs(theta(1));
p = abs(theta(2));
tj = [0; ti];
[t,Y] = ode45(@(t,Y) TIV(t,Y,beta,delta,p,c), tj, Y0);
C = Y(:,3);
[err,res] = err_func(d1,C([2:length(C)]),f);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function stop = outfun(~,~,~)
stop = false;
ttoc = toc;
if ttoc > 3
    stop = true;
    disp('Max Time Exceeded')
else
end 
end

end
