
function [theta,Theta_s,Y,ti,Yf,tf,err,AIC,res,L] = fit_TEIV(dat,Theta,q,dis,dis_data,leg)

ti = dat(:,1);
d1 = dat(:,2);
% [ti,d1] = dat_func(dat,5);
t_fine = linspace(0,ti(length(ti)));

beta = Theta(1);
p = Theta(2);
delta = Theta(3);
c = Theta(4);
kappa = Theta(5);
T0 = Theta(6);
V0 = Theta(7);
Y0 = [T0,0,0,V0];

beta_0 = beta;
delta_0 = delta;
p_0 = p;
c_0 = c;
kappa_0 = kappa;
V0_0 = V0;
T0_0 = T0;

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if q == 1
theta_0 = [beta_0, p_0, delta_0, c_0, V0_0];
elseif q == 2
theta_0 = [p_0, delta_0, c_0, V0_0];
elseif q == 3
theta_0 = [beta_0, delta_0, c_0, V0_0];
elseif q == 4
theta_0 = [beta_0, p_0, c_0, V0_0];
elseif q == 5
theta_0 = [beta_0, p_0, delta_0, V0_0];
elseif q == 6
theta_0 = [beta_0, p_0, delta_0, c_0];
end

% options = optimset('MaxFunEvals',1e5,'MaxIter',1e4,'TolFun',1e-6,'TolX',1e-6);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',1e5,'MaxIter',1e4);
tic
theta = fminsearch(@(theta) fit_err_func(theta),theta_0,options);
theta = abs(theta);

if q == 1
beta = theta(1);
p = theta(2);
delta = theta(3);
c = theta(4);
V0 = theta(5);
Y0 = [T0,0,0,V0];
    
elseif q == 2
p = theta(1);
delta = theta(2);
c = theta(3);
V0 = theta(4);
Y0 = [T0,0,0,V0];  

elseif q == 3
beta = theta(1);
delta = theta(2);
c = theta(3);
V0 = theta(4);
Y0 = [T0,0,0,V0];

elseif q == 4
beta = theta(1);
p = theta(2);
c = theta(3);
V0 = theta(4);
Y0 = [T0,0,0,V0];

elseif q == 5
beta = theta(1);
p = theta(2);
delta = theta(3);
V0 = theta(4);
Y0 = [T0,0,0,V0];

elseif q == 6
beta = theta(1);
p = theta(2);
delta = theta(3);
c = theta(4);
Y0 = [T0,0,0,V0];
    
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % Fit beta, delta, p, c, kappa
% 
% if u == 1
% theta_0 = [beta_0, delta_0, p_0, c_0, kappa_0];
% theta = fminsearch(@(theta) odefit_1(theta),theta_0);
% theta = abs(theta);
% beta = abs(theta(1));
% delta = abs(theta(2));
% p = abs(theta(3));
% c = abs(theta(4));
% kappa = abs(theta(5));
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % Fit beta, delta, p, c
% 
% if u == 2
%     
% theta_0 = [beta_0, delta_0, p_0, c_0];  
% theta = fminsearch(@(theta) odefit_2(theta),theta_0);
% theta = abs(theta);
% beta = abs(theta(1));
% delta = abs(theta(2));
% p = abs(theta(3));
% c = abs(theta(4));
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % Fit beta, p
% 
% if u == 3
% theta_0 = [beta_0, p_0];  
% theta = fminsearch(@(theta) odefit_3(theta),theta_0);
% theta = abs(theta);
% beta = theta(1);
% p = theta(2);
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % Fit beta, p, V0
% 
% if u == 4
% theta_0 = [beta_0, p_0, V0_0];  
% theta = fminsearch(@(theta) odefit_4(theta),theta_0);
% theta = abs(theta);
% beta = theta(1);
% p = theta(2);
% V0 = theta(3);
% Y0 = [T0,0,0,V0];
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % Fit beta, p, T0
% 
% if u == 5
% theta_0 = [beta_0, p_0, T0_0];  
% theta = fminsearch(@(theta) odefit_5(theta),theta_0);
% theta = abs(theta);
% beta = theta(1);
% p = theta(2);
% T0 = theta(3);
% Y0 = [T0,0,0,V0];
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % Fit beta, p, delta, c, kappa, V0
% 
% if u == 6   
% theta_0 = [beta_0, alpha_0, delta_0, c_0, kappa_0, V0_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
% theta = fminsearch(@(theta) odefit_6(theta),theta_0,options);
% theta = abs(theta);
% beta = abs(theta(1));
% alpha = abs(theta(2));
% delta = abs(theta(3));
% c = abs(theta(4));
% kappa = abs(theta(5));
% V0 = abs(theta(6));
% p = alpha/beta;
% Y0 = [T0,0,0,V0];
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % Fit beta, p, delta, c, V0
% 
% if u == 7 
% theta_0 = [beta_0, p_0, delta_0, c_0, V0_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
% theta = fminsearch(@(theta) odefit_7(theta),theta_0,options);
% theta = abs(theta);
% beta = abs(theta(1));
% p = abs(theta(2));
% delta = abs(theta(3));
% c = abs(theta(4));
% V0 = abs(theta(5));
% Y0 = [T0,0,0,V0];
% end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[err,res,L] = fit_err_func(theta);
pm = length(theta);
nd = length(ti);
AIC = nd*log(err/nd) + 2*(pm+1) + (2*(pm+1)*(pm+2))/(nd - pm);
Theta_s = [beta,p,delta,c,kappa,T0,V0];

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sol = ode45(@(t,Y) TEIV(t,Y,beta,delta,p,c,kappa), t_fine, Y0);
Yf = deval(sol,t_fine)';
tf = t_fine;

if dis == 1
p2 = semilogy(tf,Yf(:,4),'Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(ti,d1,50,'k','filled');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)
if dis_data == 1 && leg == 1
legend([p1 p2],{'Data','TEIV Model'},'FontSize',18);
end
xlim([0 ti(nd)]);
shg
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% function err = odefit_1(theta)
% beta = abs(theta(1));
% delta = abs(theta(2));
% p = abs(theta(3));
% c = abs(theta(4));
% kappa = abs(theta(5));
% err = fit_err_func();
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% function err = odefit_2(theta)
% beta = abs(theta(1));
% delta = abs(theta(2));
% p = abs(theta(3));
% c = abs(theta(4));
% err = fit_err_func();
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% function err = odefit_3(theta)
% theta = abs(theta);
% beta = theta(1);
% p = theta(2);
% err = fit_err_func();
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% function err = odefit_4(theta)
% theta = abs(theta);
% beta = theta(1);
% p = theta(2);
% V0 = theta(3);
% Y0 = [T0,0,0,V0];
% err = fit_err_func();
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% function err = odefit_5(theta)
% theta = abs(theta);
% beta = theta(1);
% p = theta(2);
% T0 = theta(3);
% Y0 = [T0,0,0,V0];
% err = fit_err_func();
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% function err = odefit_6(theta)
% 
% beta = abs(theta(1));
% alpha = abs(theta(2));
% delta = abs(theta(3));
% c = abs(theta(4));
% kappa = abs(theta(5));
% V0 = abs(theta(6));
% p = alpha/beta;
% Y0 = [T0,0,0,V0];
% err = fit_err_func();
% end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% function err = odefit_7(theta)
% 
% beta = abs(theta(1));
% p = abs(theta(2));
% delta = abs(theta(3));
% c = abs(theta(4));
% V0 = abs(theta(5));
% Y0 = [T0,0,0,V0];
% err = fit_err_func();
% end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [err,res,L] = fit_err_func(theta)
    
if q == 1
beta = theta(1);
p = theta(2);
delta = theta(3);
c = theta(4);
V0 = theta(5);
Y0 = [T0,0,0,V0];
    
elseif q == 2
p = theta(1);
delta = theta(2);
c = theta(3);
V0 = theta(4);
Y0 = [T0,0,0,V0];  

elseif q == 3
beta = theta(1);
delta = theta(2);
c = theta(3);
V0 = theta(4);
Y0 = [T0,0,0,V0];

elseif q == 4
beta = theta(1);
p = theta(2);
c = theta(3);
V0 = theta(4);
Y0 = [T0,0,0,V0];

elseif q == 5
beta = theta(1);
p = theta(2);
delta = theta(3);
V0 = theta(4);
Y0 = [T0,0,0,V0];

elseif q == 6
beta = theta(1);
p = theta(2);
delta = theta(3);
c = theta(4);
Y0 = [T0,0,0,V0];
    
end
    
sol = ode45(@(t,Y) TEIV(t,Y,beta,delta,p,c,kappa),t_fine, Y0);
Y = deval(sol,ti)';
C = Y(:,4);
[err,res] = err_func(d1,C,0.3,5);
[~,~,L] = Likelihood(d1,C,0.3,1);
end

%% Stop function if optimisation takes too long
function stop = outfun(~,~,~)
stop = false;
ttoc = toc;
if ttoc > 5
    stop = true;
    disp('Max Time Exceeded')
else
end 
end

end
