%% Fit only beta and p in IR model

function [theta,Theta_s,Yf,tf,err,AIC,res] = fit_IR_simple(dat,Theta,u,dis,dis_data)

ti = dat(:,1);
d1 = dat(:,2);
t_fine = linspace(0,ti(length(ti)));

beta = abs(Theta(1));
p = abs(Theta(2));
delta = abs(Theta(3));
c = abs(Theta(4));
kappa = abs(Theta(5));
s = abs(Theta(6));
r = abs(Theta(7));
f = abs(Theta(8));
k = abs(Theta(9));
lambda = abs(Theta(10));
tau = abs(Theta(11));
gamma = Theta(12);
w = Theta(13);
mu = Theta(14);
T0 = Theta(15);
V0 = Theta(16);
T0 = 4e8;
V0 = 0.25;


beta_0 = beta;
p_0 = p;
s_0 = s;
r_0 = r;
f_0 = f;
k_0 = k;
lambda_0 = lambda;
tau_0 = tau;
gamma_0 = gamma;
w_0 = w;
mu_0 = mu;
V0_0 = V0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 2 par: beta, p

if u == 1
theta_0 = [beta_0,p_0];
options = optimset('PlotFcns',@optimplotfval);
theta = fminsearch(@(theta) odefit_1(theta),theta_0);
theta = abs(theta);    
beta = theta(1);
p = theta(2);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[err,res] = fit_err_func();
pm = length(theta);
nd = length(ti);
AIC = nd*log(err/nd) + 2*(pm+1) + (2*(pm+1)*(pm+2))/(nd - pm);
Theta_s = [beta,p,delta,c,kappa,s,r,f,k,lambda,tau,gamma,w,mu,T0,V0];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sol =  dde23(@(t,Y,Z) IR(t,Y,Z,beta,p,delta,c,kappa,s,r,f,k,lambda,tau,gamma,w,mu), tau, @(t) history(t,T0,V0),t_fine);
Yf = deval(sol,t_fine)';
tf = t_fine;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if dis == 1
figure
p2 = semilogy(tf,Yf(:,5),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(ti,d1,50,'k','filled');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)
legend([p1 p2],{'Data','IR Model'},'FontSize',18);
shg
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_1(theta)
theta = abs(theta);    
beta = theta(1);
p = theta(2);
err = fit_err_func();
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [err,res] = fit_err_func()
sol =  dde23(@(t,Y,Z) IR(t,Y,Z,beta,p,delta,c,kappa,s,r,f,k,lambda,tau,gamma,w,mu), tau, @(t) history(t,T0,V0),t_fine);
Y = deval(sol,ti)';
C = Y(:,5);
[err,res] = err_func(d1,C,5);
end

end

