
function [err,Theta_s] = fit_IR_prac_id(dat,Theta,sigma,u,b)

%% Synthetic data
t1 = [1:size(dat,1)]';
t2 = t1; t3 = t1; t4 = t1; t5 = t1; t6 = t1; 
d1 = dat(:,1);
d2 = dat(:,2);
d3 = dat(:,3);
d5 = dat(:,4);
d6 = dat(:,5);
tf = linspace(0,t1(length(t1)));

%% Define parameters from Theta
[beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k,T0,V0] = Theta_func_new(Theta);
Y0 = [T0,0,0,0,V0,0,0];

%% Initial guesses
beta_0 = beta;
p_0 = p;
tau_0 = tau;
s_0 = s;
f_0 = f;
r_0 = r;
m_0 = m;
k_0 = k;
V0_0 = V0;
alpha_0 = beta*p;

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 8 par: beta, p, V0, s, tau, f, r, k

if u == 1
theta_0 = [beta_0, alpha_0, V0_0, s_0, tau_0, f_0, r_0, k_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_1(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
V0 = theta(3);
s = theta(4);
tau = theta(5);
f = theta(6);
r = theta(7);
k = theta(8);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 7 par: p, V0, s, tau, f, r, k
% Fix beta

if u == 2
theta_0 = [alpha_0, V0_0, s_0, tau_0, f_0, r_0, k_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_2(theta),theta_0,options);
theta = abs(theta);    
alpha = theta(1);
V0 = theta(2);
s = theta(3);
tau = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 7 par: beta, V0, s, tau, f, r, k
% Fix p

if u == 3
theta_0 = [beta_0, V0_0, s_0, tau_0, f_0, r_0, k_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_3(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
V0 = theta(2);
s = theta(3);
tau = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 7 par: beta, p, s, tau, f, r, k
% Fix V0

if u == 4
theta_0 = [beta_0, alpha_0, s_0, tau_0, f_0, r_0, k_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_4(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 7 par: beta, p, V0, tau, f, r, k
% Fix s

if u == 5
theta_0 = [beta_0, alpha_0, V0_0, tau_0, f_0, r_0, k_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_5(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
V0 = theta(3);
tau = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 7 par: beta, p, V0, s, f, r, k
% Fix tau

if u == 6
theta_0 = [beta_0, alpha_0, V0_0, s_0, f_0, r_0, k_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_6(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
V0 = theta(3);
s = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 7 par: beta, p, V0, s, tau, r, k
% Fix f

if u == 7
theta_0 = [beta_0, alpha_0, V0_0, s_0, tau_0, r_0, k_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_7(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
V0 = theta(3);
s = theta(4);
tau = theta(5);
r = theta(6);
k = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 7 par: beta, p, V0, s, tau, f, k
% Fix r

if u == 8
theta_0 = [beta_0, alpha_0, V0_0, s_0, tau_0, f_0, k_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_8(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
V0 = theta(3);
s = theta(4);
tau = theta(5);
f = theta(6);
k = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 7 par: beta, p, V0, s, tau, f, r
% Fix k

if u == 9
theta_0 = [beta_0, alpha_0, V0_0, s_0, tau_0, f_0, r_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_9(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
V0 = theta(3);
s = theta(4);
tau = theta(5);
f = theta(6);
r = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
end


%% Calculate Error %%%%%%%%%%%%%%%%%%%%%%%

err = fit_err_func(b);
Theta_s = [beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k,T0,V0];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_1(theta)
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
V0 = theta(3);
s = theta(4);
tau = theta(5);
f = theta(6);
r = theta(7);
k = theta(8);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function err = odefit_2(theta)
theta = abs(theta);    
alpha = theta(1);
V0 = theta(2);
s = theta(3);
tau = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_3(theta)
theta = abs(theta);    
beta = theta(1);
V0 = theta(2);
s = theta(3);
tau = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_4(theta)
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_5(theta)
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
V0 = theta(3);
tau = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_6(theta)
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
V0 = theta(3);
s = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_7(theta)
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
V0 = theta(3);
s = theta(4);
tau = theta(5);
r = theta(6);
k = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_8(theta)
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
V0 = theta(3);
s = theta(4);
tau = theta(5);
f = theta(6);
k = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_9(theta)
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
V0 = theta(3);
s = theta(4);
tau = theta(5);
f = theta(6);
r = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% Error Function
function err = fit_err_func(b)
    
%% Create time vectors
t1a = [0; t1];
t2a = [0; t2];
t3a = [0; t3];
t5a = [0; t5];
t6a = [0; t6];

%% Evaluate immunosupressed mice models

sol_1 = Vi_func(tf,2);
sol_2 = Vi_func(tf,1);
Y1 = deval(sol_1,t1a)';
Y2 = deval(sol_1,t2a)';
Y3 = deval(sol_1,t3a)';
Y5 = deval(sol_2,t5a)';
Y6 = deval(sol_2,t6a)';

C1 = Y1(:,5);
C2 = Y2(:,4)/T0;
C3 = Y3(:,7);
C5 = Y5(:,5);
C6 = Y6(:,4)/T0;

err1 = err_func(d1,C1([2:length(C1)]),sigma(1),5);
err2 = err_func(d2,C2([2:length(C2)]),sigma(2),6);
err3 = err_func(d3,C3([2:length(C3)]),sigma(3),5);
err5 = err_func(d5,C5([2:length(C5)]),sigma(1),5);
err6 = err_func(d6,C6([2:length(C6)]),sigma(2),6);

%%% Calculate error 
% if b == 1
% err = err1 + err2 + err3 + err5 + err6;
% 
% elseif b == 2
% err = err1 + err2 + err3;
% 
% elseif b == 3
% err = err1 + err2 + err5 + err6;
% 
% elseif b == 4
% err = err1 + err3 + err5;
% 
% elseif b == 5
% err = err2 + err3 + err6;
% 
% elseif b == 6
% err = err1;

if b == 1
err = err1 + err2 + err3;

elseif b == 2
err = err1 + err2;

elseif b == 3
err = err1 + err3;

elseif b == 4
err = err2 + err3;

elseif b == 5
err = err1;

elseif b == 6
err = err2;

elseif b == 7
err = err3;

end

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Stop function if optimisation takes too long
function stop = outfun(~,~,~)
stop = false;
ttoc = toc;
if ttoc > 30
    stop = true;
    disp('Max Time Exceeded')
else
end 
end

%% Function to evaluate model
function sol = Vi_func(t,z)
if z == 1
sol =  ode45(@(t,Y) IR_new(t,Y,beta,p,delta,c,kappa,tau,s,0,r,m,gamma,k), t, Y0); 
elseif z == 2
sol =  ode45(@(t,Y) IR_new(t,Y,beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k), t, Y0); 
end
end


end

