
function [theta,Theta_s,Y,tf,err,res] = fit_IR_ode(dat,Theta,sigma,u,b,dis,dis_data)

%% Get mice data
[t1,d1,t2,d2,t3,d3,t4,d4,t5,d5,t6,d6,~,~,t8,d8] = dat_func(dat,5);
tf = linspace(0,t1(length(t1)));

%% Synthetic data
% t1 = [1:12]';
% t2 = t1; t3 = t1; t4 = t1; t5 = t1; t6 = t1;
% d1 = dat(:,1);
% d2 = dat(:,2);
% d3 = dat(:,3);
% d4 = dat(:,4);
% d5 = d1;
% d6 = d2;
% t_fine = linspace(0,t1(length(t1)));

%% Define parameters from Theta
[beta,p,delta,c,kappa,w,mu,eta,s,f,r,m,gamma,k,T0,V0] = Theta_func(Theta);
Y0 = [T0,0,0,0,V0,0,0,0];

%% Initial guesses
beta_0 = beta;
p_0 = p;
w_0 = w;
mu_0 = mu;
eta_0 = eta;
s_0 = s;
f_0 = f;
r_0 = r;
m_0 = m;
k_0 = k;
V0_0 = V0;
alpha_0 = beta*p;

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit Immunosupressed Mice
% Fit 7 par: beta, p, w, mu, eta, s, V0

if u == 1
b = 1;
theta_0 = [beta_0, alpha_0, w_0, mu_0, eta_0, s_0, V0_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_1(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
w = theta(3);
mu = theta(4);
eta = theta(5);
s = theta(6);
V0 = theta(7);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0,0];
end

%% Evaluate models at best-fit parameters %%%%%%%%%%%%%%%%%%%%%%%

[err,res] = fit_err_func(b);
Theta_s = [beta,p,delta,c,kappa,w,mu,eta,s,f,r,m,gamma,k,T0,V0];
sol1 = Vi_func(tf,b);
Y = deval(sol1,tf)';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Plot best-fit models

if b == 2
if dis == 1
figure
p2 = semilogy(tf,Y(:,5),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t1,d1,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18);


figure
p2 = semilogy(tf,Y(:,4)/T0,'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t2,d2,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Fraction of Dead Cells','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18,'location','northwest');


figure
p2 = semilogy(tf,Y(:,8),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t3,d3,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Adaptive IR','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18,'location','southeast');
ylim([1 1e3])
xlim([0 12])


figure
p2 = semilogy(tf,Y(:,6)+Y(:,7),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t4,d4,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18,'location','southeast');
ylim([1 1e3])
xlim([0 12])
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if b == 1
if dis == 1
figure
p2 = semilogy(tf,Y(:,5),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t5,d5,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18);


figure
p2 = plot(tf,Y(:,4)/T0,'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t6,d6,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Fraction of Dead Cells','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18,'location','northwest');


figure
p2 = semilogy(tf,Y(:,6)+Y(:,7),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t8,d8,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18,'location','southeast');
ylim([1 1e3])
xlim([0 12])
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_1(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
w = theta(3);
mu = theta(4);
eta = theta(5);
s = theta(6);
V0 = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Error Function
function [err,res] = fit_err_func(b)
%% Create time vectors
t1a = [0; t1];
t2a = [0; t2];
t3a = [0; t3];
t4a = [0; t4];
t5a = [0; t5];
t6a = [0; t6];
t8a = [0; t8];

sol = Vi_func(tf,b);

%% Evaluate healthy mice models
if b == 2
Y1 = deval(sol,t1a)';
Y2 = deval(sol,t2a)';
Y3 = deval(sol,t3a)';
Y4 = deval(sol,t4a)';

C1 = Y1(:,5);
C2 = Y2(:,4)/T0;
C3 = Y3(:,8);
C4 = Y4(:,6)+Y4(:,7);

[err1,res1] = err_func(d1,C1([2:length(C1)]),sigma(1),5);
[err2,res2] = err_func(d2,C2([2:length(C2)]),sigma(2),6);
[err3,res3] = err_func(d3,C3([2:length(C3)]),sigma(3),5);
[err4,res4] = err_func(d4,C4([2:length(C4)]),sigma(4),5);

%% Evaluate immunosupressed mice models
elseif b == 1
Y5 = deval(sol,t5a)';
Y6 = deval(sol,t6a)';
Y8 = deval(sol,t8a)';

C5 = Y5(:,5);
C6 = Y6(:,4)/T0;
C8 = Y8(:,6)+Y8(:,7);

[err5,res5] = err_func(d5,C5([2:length(C5)]),sigma(5),5);
[err6,res6] = err_func(d6,C6([2:length(C6)]),sigma(6),6);
[err8,res8] = err_func(d8,C8([2:length(C8)]),sigma(7),5);
end

%% Calculate error and residuals
if b == 1
err = err5 + err6 + err8;
res(1,1:length(res5)) = res5;
res(2,1:length(res6)) = res6;
res(3,1:length(res8)) = res8;

elseif b == 2
err = err1 + err2 + err3 + err4;
res(1,1:length(res1)) = res1;
res(2,1:length(res2)) = res2;
res(3,1:length(res3)) = res3;
res(3,1:length(res4)) = res4;

end

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Stop function if optimisation takes too long
function stop = outfun(~,~,~)
stop = false;
ttoc = toc;
if ttoc > 30
    stop = true;
    disp('Max Time Exceeded')
else
end 
end

%% Function to evaluate model
function sol = Vi_func(t,b)
if b == 1
sol =  ode45(@(t,Y) IR_ode(t,Y,beta,p,delta,c,kappa,w,mu,eta,s,0,r,m,gamma,k), t, Y0); 
elseif b == 2
sol =  ode45(@(t,Y) IR_ode(t,Y,beta,p,delta,c,kappa,w,mu,eta,s,f,r,m,gamma,k), t, Y0); 
end
end


end

