
function [theta,Theta_s,Y,tf,err,res] = fit_IR_new(dat,Theta,sigma,u,b,dis,dis_data)

%% Get mice data
[t1,d1,t2,d2,t3,d3,t4,d4,t5,d5,t6,d6,~,~,t8,d8] = dat_func(dat,5);
tf = linspace(0,t1(length(t1)));

%% Synthetic data
% t1 = [1:12]';
% t2 = t1; t3 = t1; t4 = t1; t5 = t1; t6 = t1; t8 = t1;
% d1 = dat(:,1);
% d2 = dat(:,2);
% d3 = dat(:,3);
% d4 = dat(:,4);
% d5 = d1;
% d6 = d2;
% d8 = d4;
% tf = linspace(0,t1(length(t1)));

%% Define parameters from Theta
[beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k,T0,V0] = Theta_func_new(Theta);
Y0 = [T0,0,0,0,V0,0,0];

%% Initial guesses
beta_0 = beta;
p_0 = p;
tau_0 = tau;
s_0 = s;
f_0 = f;
r_0 = r;
m_0 = m;
k_0 = k;
V0_0 = V0;
alpha_0 = beta*p;


%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit Immunosuppressed Mice
% Fit 5 par: beta, p, tau, s, V0

if u == 1
b = 1;
theta_0 = [beta_0, alpha_0, tau_0, s_0, V0_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_1(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
tau = theta(3);
s = theta(4);
V0 = theta(5);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit Healthy Mice
% Fit 8 par: beta, p, tau, s, f, r, k, V0

if u == 2
b = 2;
theta_0 = [beta_0, alpha_0, tau_0, s_0, f_0, r_0, k_0, V0_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_2(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
tau = theta(3);
s = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
V0 = theta(8);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit Healthy Mice
% Fit 9 par: beta, p, tau, s, f, r, k, m, V0

if u == 3
b = 2;
theta_0 = [beta_0, alpha_0, tau_0, s_0, f_0, r_0, k_0, m_0, V0_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_3(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
tau = theta(3);
s = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
m = Theta(8);
V0 = theta(9);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit Healthy Mice
% Fit 8 par: beta, p, s, f, r, k, m, V0

if u == 4
b = 2;
theta_0 = [beta_0, alpha_0, s_0, f_0, r_0, k_0, m_0, V0_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
theta = fminsearch(@(theta) odefit_4(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
f = theta(4);
r = theta(5);
k = theta(6);
m = Theta(7);
V0 = theta(8);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit Immunosuppressed Mice (Fix beta)
% Fit 4 par: p, tau, s, V0

if u == 5
b = 1;
theta_0 = [alpha_0, tau_0, s_0, V0_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_5(theta),theta_0,options);
theta = abs(theta);    
alpha = theta(1);
tau = theta(2);
s = theta(3);
V0 = theta(4);
p = alpha/beta;
theta(1) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit Immunosuppressed Mice (Fix p)
% Fit 4 par: beta, tau, s, V0

if u == 6
b = 1;
theta_0 = [beta_0, tau_0, s_0, V0_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_6(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
tau = theta(2);
s = theta(3);
V0 = theta(4);
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit Immunosuppressed Mice (Fix tau)
% Fit 4 par: beta, p, s, V0

if u == 7
b = 1;
theta_0 = [beta_0, alpha_0, s_0, V0_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_7(theta),theta_0,options);
theta = abs(theta); 
beta = theta(1);
alpha = theta(2);
s = theta(3);
V0 = theta(4);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit Immunosuppressed Mice (Fix s)
% Fit 4 par: beta, p, tau, V0

if u == 8
b = 1;
theta_0 = [beta_0, alpha_0, tau_0, V0_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_8(theta),theta_0,options);
theta = abs(theta); 
beta = theta(1);
alpha = theta(2);
tau = theta(3);
V0 = theta(4);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit Immunosuppressed Mice (Fix s)
% Fit 4 par: beta, p, tau, s

if u == 9
b = 1;
theta_0 = [beta_0, alpha_0, tau_0, s_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_9(theta),theta_0,options);
theta = abs(theta); 
beta = theta(1);
alpha = theta(2);
tau = theta(3);
s = theta(4);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit Healthy and Suppressed Mice
% Fit 8 par: beta, p, tau, s, f, r, k, V0

if u == 10
b = 3;
theta_0 = [beta_0, alpha_0, tau_0, s_0, f_0, r_0, k_0, V0_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_2(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
tau = theta(3);
s = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
V0 = theta(8);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%% Evaluate models at best-fit parameters %%%%%%%%%%%%%%%%%%%%%%%

[err,res] = fit_err_func(b);
Theta_s = [beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k,T0,V0];

if b == 1 || b == 2
sol1 = Vi_func(tf,b);
Y = deval(sol1,tf)';
elseif b == 3
sol1 = Vi_func(tf,2);
Y1 = deval(sol1,tf)';
sol2 = Vi_func(tf,1);
Y2 = deval(sol2,tf)';
Y = [Y1,Y2];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Plot best-fit models

if b == 2
if dis == 1
figure
p2 = semilogy(tf,Y(:,5),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t1,d1,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18);


figure
plot(tf,Y(:,4)/T0,'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t2,d2,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Fraction of Dead Cells','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18,'location','northwest');


figure
p2 = semilogy(tf,Y(:,7),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t3,d3,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Adaptive IR','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18);
ylim([1 1e3])
xlim([0 12])


figure
p2 = semilogy(tf,IFN(tf),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t4,d4,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18);
ylim([1 1e3])
xlim([0 12])
end

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if b == 1
if dis == 1
figure
p2 = semilogy(tf,Y(:,5),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t5,d5,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18);


figure
p2 = plot(tf,Y(:,4)/T0,'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t6,d6,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Fraction of Dead Cells','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18,'location','northwest');


figure
p2 = semilogy(tf,IFN(tf),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t8,d8,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
legend([p1 p2],{'Data',' Model'},'FontSize',18,'location','southeast');
ylim([1 1e3])
xlim([0 12])
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if b == 3
if dis == 1
figure
p3 = semilogy(tf,Y1(:,5),'b','Linewidth',1.5);
hold on
p4 = semilogy(tf,Y2(:,5),'r','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t1,d1,80,'markerfacecolor','b','markeredgecolor','k');
    p2 = scatter(t5,d5,80,'markerfacecolor','r','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)
legend([p1 p2 p3 p4],{'Competent Data','Suppressed Data','Competent Model','Suppressed Model'},'FontSize',18,'location','northwest');

figure
p3 = plot(tf,Y1(:,4)/T0,'b','Linewidth',1.5);
hold on
p4 = plot(tf,Y2(:,4)/T0,'r','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t2,d2,80,'markerfacecolor','b','markeredgecolor','k');
    p2 = scatter(t6,d6,80,'markerfacecolor','r','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Fraction of Dead Cells','FontSize',22)
legend([p1 p2 p3 p4],{'Competent Data','Suppressed Data','Competent Model','Suppressed Model'},'FontSize',18,'location','northwest');

figure
p2 = semilogy(tf,Y1(:,7),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t3,d3,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Adaptive IR','FontSize',22)
legend([p1 p2],{'Competent Data','Competent Model'},'FontSize',18,'location','southeast');
ylim([1 1e2])
xlim([0 12])

figure
p3 = semilogy(tf,IFN(tf),'b','Linewidth',1.5);  
if  dis_data == 1
    hold on
    p1 = scatter(t4,d4,80,'markerfacecolor','b','markeredgecolor','k');
    p2 = scatter(t8,d8,80,'markerfacecolor','r','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
legend([p1 p2 p3],{'Competent Data','Suppressed Data','Model',},'FontSize',18);
ylim([1 1e3])
xlim([0 12])
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_1(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
tau = theta(3);
s = theta(4);
V0 = theta(5);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_2(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
tau = theta(3);
s = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
V0 = theta(8);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_3(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
tau = theta(3);
s = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
m = Theta(8);
V0 = theta(9);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_4(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
f = theta(4);
r = theta(5);
k = theta(6);
m = Theta(7); 
V0 = theta(8);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_5(theta)
theta = abs(theta);   
alpha = theta(1);
tau = theta(2);
s = theta(3);
V0 = theta(4);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_6(theta)
theta = abs(theta);   
beta = theta(1);
tau = theta(2);
s = theta(3);
V0 = theta(4);
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_7(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
V0 = theta(4);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_8(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
tau = theta(3);
V0 = theta(4);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_9(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
tau = theta(3);
s = theta(4);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% Error Function
function [err,res] = fit_err_func(b)
%% Create time vectors
t1a = [0; t1];
t2a = [0; t2];
t3a = [0; t3];
t4a = [0; t4];
t5a = [0; t5];
t6a = [0; t6];
t8a = [0; t8];


%% Evaluate immunosupressed mice models
if b == 1
sol = Vi_func(tf,b);
Y5 = deval(sol,t5a)';
Y6 = deval(sol,t6a)';

C5 = Y5(:,5);
C6 = Y6(:,4)/T0;

[err5,res5] = err_func(d5,C5([2:length(C5)]),sigma(1),5);
[err6,res6] = err_func(d6,C6([2:length(C6)]),sigma(2),6);


%%% Evaluate healthy mice models
elseif b == 2
sol = Vi_func(tf,b);
Y1 = deval(sol,t1a)';
Y2 = deval(sol,t2a)';
Y3 = deval(sol,t3a)';

C1 = Y1(:,5);
C2 = Y2(:,4)/T0;
C3 = Y3(:,7);

[err1,res1] = err_func(d1,C1([2:length(C1)]),sigma(1),5);
[err2,res2] = err_func(d2,C2([2:length(C2)]),sigma(2),6);
[err3,res3] = err_func(d3,C3([2:length(C3)]),sigma(3),5);

%%% Evaluate healthy and immunisuppressed mice models
elseif b == 3
sol_1 = Vi_func(tf,2);
Y1 = deval(sol_1,t1a)';
Y2 = deval(sol_1,t2a)';
Y3 = deval(sol_1,t3a)';

C1 = Y1(:,5);
C2 = Y2(:,4)/T0;
C3 = Y3(:,7);

[err1,res1] = err_func(d1,C1([2:length(C1)]),sigma(1),5);
[err2,res2] = err_func(d2,C2([2:length(C2)]),sigma(2),6);
[err3,res3] = err_func(d3,C3([2:length(C3)]),sigma(3),5);

sol_2 = Vi_func(tf,1);
Y5 = deval(sol_2,t5a)';
Y6 = deval(sol_2,t6a)';

C5 = Y5(:,5);
C6 = Y6(:,4)/T0;

[err5,res5] = err_func(d5,C5([2:length(C5)]),sigma(1),5);
[err6,res6] = err_func(d6,C6([2:length(C6)]),sigma(2),6);

end


%%% Calculate error and residuals
if b == 1
err = err5 + err6;
res(1,1:length(res5)) = res5;
res(2,1:length(res6)) = res6;

elseif b == 2
err = err1 + err2 + err3;
res(1,1:length(res1)) = res1;
res(2,1:length(res2)) = res2;
res(3,1:length(res3)) = res3;

elseif b == 3
err = err1 + err2 + err3 + err5 + err6
res(1,1:length(res1)) = res1;
res(2,1:length(res2)) = res2;
res(3,1:length(res3)) = res3;
res(5,1:length(res5)) = res5;
res(6,1:length(res6)) = res6;

end

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Stop function if optimisation takes too long
function stop = outfun(~,~,~)
stop = false;
ttoc = toc;
if ttoc > 20
    stop = true;
    disp('Max Time Exceeded')
else
end 
end

%% Function to evaluate model
function sol = Vi_func(t,b)
if b == 1
sol =  ode45(@(t,Y) IR_new(t,Y,beta,p,delta,c,kappa,tau,s,0,r,m,gamma,k), t, Y0); 
elseif b == 2
sol =  ode45(@(t,Y) IR_new(t,Y,beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k), t, Y0); 
end
end


end

