
function [theta,Theta_s,Y,ti,Yf,tf,err,AIC,res,L] = fit_IR_V(dat,Theta,q,dis,dis_data)

ti = dat(:,1);
d1 = dat(:,2); 
tf = linspace(0,ti(length(ti)));

[beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k,T0,V0] = Theta_func_new(Theta);
Y0 = [T0,0,0,0,V0,0,0];

beta_0 = beta;
p_0 = p;
tau_0 = tau;
s_0 = s;
f_0 = f;
r_0 = r;
k_0 = k;
V0_0 = V0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if q == 1

theta_0 = [beta_0, p_0, tau_0, s_0, f_0, r_0, k_0, V0_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_1(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
p = theta(2);
tau = theta(3);
s = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
V0 = theta(8);
Y0 = [T0,0,0,0,V0,0,0];

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[err,res,L,AIC] = fit_err_func();
Theta_s = [beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k,T0,V0];
Yf = Vi_func(tf);
Y = Vi_func(ti);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if dis == 1
p2 = semilogy(tf,Yf(:,5),'Linewidth',1.5);

if  dis_data == 1
    hold on
    p1 = scatter(ti,d1,50,'k','filled');
    box on 
end

xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer','FontSize',22)
xlim([0 ti(length(ti))])
if dis_data == 1
legend([p1 p2],{'Data','IR Model'},'FontSize',18);
end
ylim([1e2 1e6])
shg

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_1(theta)
theta = abs(theta);   
beta = theta(1);
p = theta(2);
tau = theta(3);
s = theta(4);
f = theta(5);
r = theta(6);
k = theta(7);
V0 = theta(8);
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func();
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [err,res,L,AIC] = fit_err_func()
Y = Vi_func(ti);
Vi = Y(:,5);
[err,res] = err_func(d1,Vi,0.3,5);
[~,~,L] = Likelihood(d1,Vi,0.3,2);
pm = length(theta_0);
nd = length(ti);
AIC = nd*log(err/nd) + 2*(pm+1) + (2*(pm+1)*(pm+2))/(nd - pm);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function Y = Vi_func(t)
sol =  ode45(@(t,Y) IR_new(t,Y,beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k), tf, Y0); 
Y = deval(sol,t)';
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Stop function if optimisation takes too long
function stop = outfun(~,~,~)
stop = false;
ttoc = toc;
if ttoc > 60
    stop = true;
    disp('Max Time Exceeded')
else
end 
end

end
