
function [theta,Theta_s,Yf_1,tf_1,Yf_2,tf_2,err,AIC,res] = fit_IR(dat,Theta,sigma,u,b,dis,dis_data)

%% Get mice data
[t1,d1,t2,d2,t3,d3,t4,d4,t5,d5,t6,d6,~,~,t8,d8] = dat_func(dat,5);
t_fine = linspace(0,t1(length(t1)));

%% Synthetic data
% t1 = [1:12]';
% t2 = t1; t3 = t1; t4 = t1; t5 = t1; t6 = t1;
% d1 = dat(:,1);
% d2 = dat(:,2);
% d3 = dat(:,3);
% d4 = dat(:,4);
% d5 = d1;
% d6 = d2;
% t_fine = linspace(0,t1(length(t1)));

%% Define parameters from Theta
beta = abs(Theta(1));
p = abs(Theta(2));
delta = abs(Theta(3));
c = abs(Theta(4));
kappa = abs(Theta(5));
s = abs(Theta(6));
r = abs(Theta(7));
f = abs(Theta(8));
k = abs(Theta(9));
lambda = abs(Theta(10));
tau = abs(Theta(11));
gamma = Theta(12);
w = Theta(13);
mu = Theta(14);
T0 = Theta(15);
V0 = Theta(16);
nu = Theta(17);
Y0 = [T0,0,0,0,V0,0,0];

%% Initial guesses
beta_0 = beta;
p_0 = p;
s_0 = s;
r_0 = r;
f_0 = f;
k_0 = k;
lambda_0 = lambda;
tau_0 = tau;
gamma_0 = gamma;
w_0 = w;
mu_0 = mu;
V0_0 = V0;
alpha_0 = beta*p;
delta_0 = delta;
c_0 = c;
nu_0 = 1;

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 10 par: beta, p, s, r, f, k, lambda, tau, gamma, V0

if u == 1
b = 1;
theta_0 = [beta_0, p_0, s_0, r_0, f_0, k_0, lambda_0, tau_0, gamma_0, V0_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_1(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
p = theta(2);
s = theta(3);
r = theta(4);
f = theta(5);
k = theta(6);
lambda = theta(7);
tau = theta(8);
gamma = theta(9);
V0 = theta(10);
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 2 par: w, mu

if u == 2
b = 2;
theta_0 = [w_0, mu_0];
options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
% options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_2(theta),theta_0,options);
theta = abs(theta);    
w = theta(1);
mu = theta(2);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 12 par: beta, p, s, r, f, k, lambda, tau, gamma, w, mu, V0

if u == 3
b = 3;
theta_0 = [beta_0, p_0, s_0, r_0, f_0, k_0, lambda_0, tau_0, gamma_0, w_0, mu_0, V0_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_3(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
p = theta(2);
s = theta(3);
r = theta(4);
f = theta(5);
k = theta(6);
lambda = theta(7);
tau = theta(8);
gamma = theta(9);
w = theta(10);
mu = theta(11);
V0 = theta(12);
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit 11 par: beta, p, s, r, f, k, lambda, tau, gamma, w, mu

if u == 4
b = 3;
theta_0 = [beta_0, p_0, s_0, r_0, f_0, k_0, lambda_0, tau_0, gamma_0, w_0, mu_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
options = optimset('PlotFcns',@optimplotfval,'MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_4(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
p = theta(2);
s = theta(3);
r = theta(4);
f = theta(5);
k = theta(6);
lambda = theta(7);
tau = theta(8);
gamma = theta(9);
w = theta(10);
mu = theta(11);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit supressed mice
% 4 par: beta, p, s, v0

if u == 5
b = 4;
theta_0 = [beta_0, alpha_0, s_0, V0_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_5(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
V0 = theta(4);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit supressed mice
% 4 par: beta, p, s, tau

if u == 6
b = 4;
theta_0 = [beta_0, alpha_0, s_0, tau_0];
% options = optimset('MaxFunEvals',1e4,'MaxIter',1e3);
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_6(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
p = alpha/beta;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit supressed mice
% 5 par: beta, p, s, tau, V0

if u == 7
b = 4;

theta_0 = [beta_0, alpha_0, s_0, tau_0, V0_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_7(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];

% theta_0 = [beta_0, alpha_0, s_0, tau_0, 0];
% options = optimset('MaxFunEvals',5000,'MaxIter',5000);
% theta = fminsearch(@(theta) odefit_7(theta),theta_0,options);
% theta = abs(theta);    
% beta = theta(1);
% alpha = theta(2);
% s = theta(3);
% tau = theta(4);
% x = theta(5);
% V0 = con_func(x,1e2,4e4);
% p = alpha/beta;
% Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healthy mice
% 5 par: beta, p, r, f, k

if u == 8
b = 5;
theta_0 = [beta_0, alpha_0, r_0, f_0, k_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_8(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
r = theta(3);
f = theta(4);
k = theta(5);
p = alpha/beta;
theta(2) = p;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healthy mice
% 6 par: beta, p, r, f, k, V0

if u == 9
b = 5;
theta_0 = [beta_0, alpha_0, r_0, f_0, k_0, V0_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_9(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
r = theta(3);
f = theta(4);
k = theta(5);
V0 = theta(6);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit supressed mice
% 6 par: beta, p, s, tau, V0, delta

if u == 10
b = 4;
theta_0 = [beta_0, alpha_0, s_0, tau_0, V0_0, delta_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_10(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
delta = theta(6);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit supressed mice
% 6 par: beta, p, s, tau, V0, c

if u == 11
b = 4;
theta_0 = [beta_0, alpha_0, s_0, tau_0, V0_0, c_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_11(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
c = theta(6);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit supressed mice
% 7 par: beta, p, s, tau, V0, c, delta

if u == 12
b = 6;
theta_0 = [beta_0, alpha_0, s_0, tau_0, V0_0, c_0, delta_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_12(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
c = theta(6);
delta = theta(7);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit supressed mice
% 6 par: beta, p, s, tau, V0, nu

if u == 13
theta_0 = [beta_0, alpha_0, s_0, tau_0, V0_0, nu_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_13(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
nu = theta(6);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit supressed mice
% 7 par: beta, p, s, tau, V0, nu, c

if u == 14
theta_0 = [beta_0, alpha_0, s_0, tau_0, V0_0, nu_0, c_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_14(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
nu = theta(6);
c = theta(7);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit supressed mice
% 7 par: beta, p, s, tau, V0, nu, delta

if u == 15
theta_0 = [beta_0, alpha_0, s_0, tau_0, V0_0, nu_0, delta_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_15(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
nu = theta(6);
delta = theta(7);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit supressed mice
% 8 par: beta, p, s, tau, V0, nu, c, delta

if u == 16
theta_0 = [beta_0, alpha_0, s_0, tau_0, V0_0, nu_0, c_0, delta_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_16(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
nu = theta(6);
c = theta(7);
delta = theta(8);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice: AB and IFN functions
% 4 par: beta, p, k, V0

if u == 17
b = 7;
theta_0 = [beta_0, alpha_0, k_0, V0_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_17(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
k = theta(3);
V0 = theta(4);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice: AB and IFN functions
% 6 par: beta, p, k, V0, c, delta

if u == 18
b = 7;
theta_0 = [beta_0, alpha_0, k_0, V0_0, c_0, delta_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_18(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
k = theta(3);
V0 = theta(4);
c = theta(5);
delta = theta(6);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice: AB and IFN functions
% 5 par: beta, p, s, k, V0

if u == 19
b = 7;
theta_0 = [beta_0, alpha_0, s_0, k_0, V0_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_19(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
V0 = theta(5);
p = alpha/beta;
theta(2) = p;
Y0 = [T0,0,0,0,V0,0,0];
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit innate and adaptive to healthy mice
% 4 par: r, f, w, mu

if u == 20
b = 8;
theta_0 = [r_0, f_0, w_0, mu_0];
options = optimset('MaxFunEvals',5000,'MaxIter',5000);
theta = fminsearch(@(theta) odefit_20(theta),theta_0,options);
theta = abs(theta);    
r = theta(1);
f = theta(2);
w = theta(3);
mu = theta(4);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice to all data
% 9 par: beta, p, s, k, V0, r, f, w, mu

if u == 21
b = 9;
theta_0 = [beta_0, alpha_0, s_0, k_0, V0_0, r_0, f_0, w_0, mu_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_21(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
V0 = theta(5);
r = theta(6);
f = theta(7);
w = theta(8);
mu = theta(9);
p = alpha/beta;
theta(2) = p;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice to all data (Fix beta)
% 8 par: p, s, k, V0, r, f, w, mu

if u == 22
b = 9;
theta_0 = [alpha_0, s_0, k_0, V0_0, r_0, f_0, w_0, mu_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_22(theta),theta_0,options);
theta = abs(theta);    
alpha = theta(1);
s = theta(2);
k = theta(3);
V0 = theta(4);
r = theta(5);
f = theta(6);
w = theta(7);
mu = theta(8);
p = alpha/beta;
theta(1) = p;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice to all data (Fix p)
% 8 par: beta, s, k, V0, r, f, w, mu

if u == 23
b = 9;
theta_0 = [beta_0, s_0, k_0, V0_0, r_0, f_0, w_0, mu_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_23(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
s = theta(2);
k = theta(3);
V0 = theta(4);
r = theta(5);
f = theta(6);
w = theta(7);
mu = theta(8);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice to all data (Fix s)
% 8 par: beta, p , k, V0, r, f, w, mu

if u == 24
b = 9;
theta_0 = [beta_0, alpha_0, k_0, V0_0, r_0, f_0, w_0, mu_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_24(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
k = theta(3);
V0 = theta(4);
r = theta(5);
f = theta(6);
w = theta(7);
mu = theta(8);
p = alpha/beta;
theta(2) = p;
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice to all data (Fix k)
% 8 par: beta, p, k, V0, r, f, w, mu

if u == 25
b = 9;
theta_0 = [beta_0, alpha_0, s_0, V0_0, r_0, f_0, w_0, mu_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_25(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
V0 = theta(4);
r = theta(5);
f = theta(6);
w = theta(7);
mu = theta(8);
p = alpha/beta;
theta(2) = p;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice to all data (Fix V0)
% 8 par: beta, p, s, k, r, f, w, mu

if u == 26
b = 9;
theta_0 = [beta_0, alpha_0, s_0, k_0, r_0, f_0, w_0, mu_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_26(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
r = theta(5);
f = theta(6);
w = theta(7);
mu = theta(8);
p = alpha/beta;
theta(2) = p;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice to all data (Fix r)
% 8 par: beta, p, s, k, r, f, w, mu

if u == 27
b = 9;
theta_0 = [beta_0, alpha_0, s_0, k_0, V0_0, f_0, w_0, mu_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_27(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
V0 = theta(5);
f = theta(6);
w = theta(7);
mu = theta(8);
p = alpha/beta;
theta(2) = p;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice to all data (Fix f)
% 8 par: beta, p, s, k, V0, r, w, mu

if u == 28
b = 9;
theta_0 = [beta_0, alpha_0, s_0, k_0, V0_0, r_0, w_0, mu_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_28(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
V0 = theta(5);
r = theta(6);
w = theta(7);
mu = theta(8);
p = alpha/beta;
theta(2) = p;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice to all data (Fix w)
% 8 par: beta, p, s, k, V0, r, f, mu

if u == 29
b = 9;
theta_0 = [beta_0, alpha_0, s_0, k_0, V0_0, r_0, f_0, mu_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_29(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
V0 = theta(5);
r = theta(6);
f = theta(7);
mu = theta(8);
p = alpha/beta;
theta(2) = p;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit healhy mice to all data (Fix mu)
% 8 par: beta, p, s, k, V0, r, f, w

if u == 30
b = 9;
theta_0 = [beta_0, alpha_0, s_0, k_0, V0_0, r_0, f_0, w_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_30(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
V0 = theta(5);
r = theta(6);
f = theta(7);
w = theta(8);
p = alpha/beta;
theta(2) = p;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Fit immunopressed mice to full DDE model
% 7 par: beta, p, s, tau, V0, w, mu
if u == 31
b = 10;
theta_0 = [beta_0, alpha_0, s_0, tau_0, V0_0, w_0, mu_0];
options = optimset('OutputFcn',@outfun,'MaxFunEvals',5000,'MaxIter',5000,'Display','off');
tic
theta = fminsearch(@(theta) odefit_31(theta),theta_0,options);
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
w = theta(6);
mu = theta(7);
p = alpha/beta;
theta(2) = p;
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[err,res,AIC] = fit_err_func(b);
Theta_s = [beta,p,delta,c,kappa,s,r,f,k,lambda,tau,gamma,w,mu,T0,V0,nu];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Evaluate models at best-fit parameters
if b == 1 || b == 2 ||b == 5 || b == 7 || b == 8 
Yf_1 = Vi_func(t_fine,1);
elseif b == 3 || b == 9 || b == 10
Yf_1 = Vi_func(t_fine,2);
elseif b == 4 || b == 6
Yf_1 = 0;
end
Yf_2 = Vi_func(t_fine,3);
tf_1 = t_fine;    
tf_2 = t_fine;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Plot best-fit models

if b == 1 || b == 2 || b == 3
if dis == 1
figure
p3 = semilogy(tf_1,Yf_1(:,5),'b','Linewidth',1.5);
hold on
p4 = semilogy(tf_2,Yf_2(:,5),'r','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t1,d1,80,'markerfacecolor','b','markeredgecolor','k');
    p2 = scatter(t5,d5,80,'markerfacecolor','r','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer (PFU)','FontSize',22)
legend([p1 p2 p3 p4],{'Competent Data','Suppressed Data','Competent Model','Suppressed Model'},'FontSize',18,'location','northwest');
% saveas(gca,[pwd '/Figures/b5/u',num2str(u),'/Viral.fig']);

figure
p3 = plot(tf_1,nu*Yf_1(:,4)/T0,'b','Linewidth',1.5);
hold on
p4 = plot(tf_2,nu*Yf_2(:,4)/T0,'r','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t2,d2,80,'markerfacecolor','b','markeredgecolor','k');
    p2 = scatter(t6,d6,80,'markerfacecolor','r','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Fraction of Dead Cells','FontSize',22)
legend([p1 p2 p3 p4],{'Competent Data','Suppressed Data','Competent Model','Suppressed Model'},'FontSize',18,'location','northwest');
% saveas(gca,[pwd '/Figures/b5/u',num2str(u),'/Frac.fig']);

figure
p2 = semilogy(tf_1,Yf_1(:,7),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t3,d3,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Adaptive IR','FontSize',22)
legend([p1 p2],{'Competent Data','Competent Model'},'FontSize',18,'location','southeast');
ylim([1 1e2])
% saveas(gca,[pwd '/Figures/b5/u',num2str(u),'/A_IR.fig']);

figure
if b == 1
p3 = semilogy(t_fine,IFN(t_fine),'k','Linewidth',1.5);
elseif b == 2 || b == 3
p3 = semilogy(tf_1,Yf_1(:,6),'b','Linewidth',1.5);  
hold on
p4 = semilogy(t_fine,IFN(t_fine),'r','Linewidth',1.5);    
end
if  dis_data == 1
    hold on
    p1 = scatter(t4,d4,80,'markerfacecolor','b','markeredgecolor','k');
    p2 = scatter(t8,d8,80,'markerfacecolor','r','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
if b == 1
legend([p1 p2 p3],{'Competent Data','Suppressed Data','Model',},'FontSize',18);
elseif b == 2 || b == 3
legend([p1 p2 p3 p4],{'Competent Data','Suppressed Data','Competent Model','Suppressed Model'},'FontSize',18);
end
ylim([1 1e3])
xlim([0 12])
% saveas(gca,[pwd '/Figures/b5/u',num2str(u),'/I_IR.fig']);
end
end

if b == 4
if dis == 1
figure
p4 = semilogy(tf_2,Yf_2(:,5),'r','Linewidth',1.5);
hold on
if  dis_data == 1
    hold on
    p2 = scatter(t5,d5,80,'markerfacecolor','r','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer (PFU)','FontSize',22)
legend([p2 p4],{'Suppressed Data','Suppressed Model'},'FontSize',18,'location','northwest');
ylim([10e3 10e8])
% saveas(gca,[pwd '/Figures/b5/u',num2str(u),'/Viral.fig']);

figure
p4 = plot(tf_2,nu*Yf_2(:,4)/T0,'r','Linewidth',1.5);
hold on 
if  dis_data == 1
    hold on
    p2 = scatter(t6,d6,80,'markerfacecolor','r','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Fraction of Dead Cells','FontSize',22)
legend([p2 p4],{'Suppressed Data','Suppressed Model'},'FontSize',18,'location','northwest');
% saveas(gca,[pwd '/Figures/b5/u',num2str(u),'/Frac.fig']);

figure
p4 = semilogy(t_fine,IFN(t_fine),'r','Linewidth',1.5);    
hold on
end
if  dis_data == 1
    p2 = scatter(t8,d8,80,'markerfacecolor','r','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
legend([p2 p4],{'Suppressed Data','Suppressed Model',},'FontSize',18);
ylim([1 1e3])
xlim([0 12])
% saveas(gca,[pwd '/Figures/b5/u',num2str(u),'/I_IR.fig']);
end    

if b == 5
if dis == 1
figure
p3 = semilogy(tf_1,Yf_1(:,5),'b','Linewidth',1.5);
hold on
if  dis_data == 1
    hold on
    p1 = scatter(t1,d1,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer (PFU)','FontSize',22)
legend([p1 p3],{'Competent Data','Competent Model'},'FontSize',18,'location','northeast');
% saveas(gca,[pwd '/Figures/b5/u',num2str(u),'/Viral.fig']);

figure
p3 = plot(tf_1,nu*Yf_1(:,4)/T0,'b','Linewidth',1.5);
hold on
if  dis_data == 1
    hold on
    p1 = scatter(t2,d2,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Fraction of Dead Cells','FontSize',22)
legend([p1 p3],{'Competent Data','Competent Model'},'FontSize',18,'location','northwest');
% saveas(gca,[pwd '/Figures/b5/u',num2str(u),'/Frac.fig']);

figure
p2 = semilogy(tf_1,Yf_1(:,7),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t3,d3,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Adaptive IR','FontSize',22)
legend([p1 p3],{'Competent Data','Competent Model'},'FontSize',18,'location','southeast');
ylim([1 1e2])
% saveas(gca,[pwd '/Figures/b5/u',num2str(u),'/A_IR.fig']);

figure
p3 = semilogy(t_fine,IFN(t_fine),'k','Linewidth',1.5);
hold on
end
if  dis_data == 1
    hold on
    p1 = scatter(t4,d4,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
legend([p1 p3],{'Competent Data','Competent Model'},'FontSize',18);
ylim([1 1e3])
xlim([0 12])
% saveas(gca,[pwd '/Figures/b5/u',num2str(u),'/I_IR.fig']);
end

if b == 6
if dis == 1
figure
p4 = semilogy(tf_2,Yf_2(:,5),'r','Linewidth',1.5);
hold on
if  dis_data == 1
    hold on
    p2 = scatter(t5,d5,80,'markerfacecolor','r','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer (PFU)','FontSize',22)
legend([p2 p4],{'Suppressed Data','Suppressed Model'},'FontSize',18,'location','northwest');
ylim([10e3 10e8])

figure
p4 = plot(tf_2,nu*Yf_2(:,4)/T0,'r','Linewidth',1.5);
hold on 
if  dis_data == 1
    hold on
    p2 = scatter(t6,d6,80,'markerfacecolor','r','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Fraction of Dead Cells','FontSize',22)
legend([p2 p4],{'Suppressed Data','Suppressed Model'},'FontSize',18,'location','northwest');
% saveas(gca,[pwd '/Figures/b5/u',num2str(u),'/Frac.fig']);
end
end
   
if b == 7
if dis == 1
figure
p3 = semilogy(tf_1,Yf_1(:,5),'b','Linewidth',1.5);
hold on
if  dis_data == 1
    hold on
    p1 = scatter(t1,d1,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer (PFU)','FontSize',22)
legend([p1 p3],{'Data','Model'},'FontSize',18,'location','northeast');


figure
p3 = plot(tf_1,nu*Yf_1(:,4)/T0,'b','Linewidth',1.5);
hold on
if  dis_data == 1
    hold on
    p1 = scatter(t2,d2,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Fraction of Dead Cells','FontSize',22)
legend([p1 p3],{'Data','Model'},'FontSize',18,'location','northwest');

figure
p2 = semilogy(tf_1,AB(tf_1),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t3,d3,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Adaptive IR','FontSize',22)
legend([p1 p2],{'Data','Model'},'FontSize',18,'location','southeast');
ylim([1 1e2])

figure
p2 = semilogy(tf_1,IFN(tf_1),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t4,d4,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
legend([p1 p2],{'Data','Model'},'FontSize',18);

ylim([1 1e3])
xlim([0 12])
end
end

if b == 8 || b == 9
if dis == 1 
figure
p3 = semilogy(tf_1,Yf_1(:,5),'b','Linewidth',1.5);
hold on
if  dis_data == 1
    hold on
    p1 = scatter(t1,d1,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer (PFU)','FontSize',22)
legend([p1 p3],{'Data','Model'},'FontSize',18,'location','northeast');


figure
p3 = plot(tf_1,nu*Yf_1(:,4)/T0,'b','Linewidth',1.5);
hold on
if  dis_data == 1
    hold on
    p1 = scatter(t2,d2,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Fraction of Dead Cells','FontSize',22)
legend([p1 p3],{'Data','Model'},'FontSize',18,'location','northwest');

figure
p2 = semilogy(tf_1,Yf_1(:,7),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t3,d3,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Adaptive IR','FontSize',22)
legend([p1 p2],{'Data','Model'},'FontSize',18,'location','southeast');
ylim([1 1e2])

figure
p2 = semilogy(tf_1,Yf_1(:,6),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t4,d4,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
legend([p1 p2],{'Data','Model'},'FontSize',18);

ylim([1 1e3])
xlim([0 12])
end
end

if b == 10
if dis == 1 
figure
p3 = semilogy(tf_1,Yf_1(:,5),'b','Linewidth',1.5);
hold on
if  dis_data == 1
    hold on
    p1 = scatter(t5,d5,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Viral Titer (PFU)','FontSize',22)
legend([p1 p3],{'Data','Model'},'FontSize',18,'location','northeast');


figure
p3 = plot(tf_1,nu*Yf_1(:,4)/T0,'b','Linewidth',1.5);
hold on
if  dis_data == 1
    hold on
    p1 = scatter(t6,d6,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Fraction of Dead Cells','FontSize',22)
legend([p1 p3],{'Data','Model'},'FontSize',18,'location','northwest');


figure
p2 = semilogy(tf_1,Yf_1(:,6),'b','Linewidth',1.5);
if  dis_data == 1
    hold on
    p1 = scatter(t8,d8,80,'markerfacecolor','b','markeredgecolor','k');
    box on 
end
xlabel('Time (Days)','FontSize',22)
ylabel('Innate IR','FontSize',22)
legend([p1 p2],{'Data','Model'},'FontSize',18);

% ylim([1 1e3])
xlim([0 12])
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_1(theta)
theta = abs(theta);    
beta = theta(1);
p = theta(2);
s = theta(3);
r = theta(4);
f = theta(5);
k = theta(6);
lambda = theta(7);
tau = theta(8);
gamma = theta(9);
V0 = theta(10);
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_2(theta)
theta = abs(theta);    
w = theta(1);
mu = theta(2);
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_3(theta)
theta = abs(theta);   
beta = theta(1);
p = theta(2);
s = theta(3);
r = theta(4);
f = theta(5);
k = theta(6);
lambda = theta(7);
tau = theta(8);
gamma = theta(9);
w = theta(10);
mu = theta(11);
V0 = theta(12);
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_4(theta)
theta = abs(theta);   
beta = theta(1);
p = theta(2);
s = theta(3);
r = theta(4);
f = theta(5);
k = theta(6);
lambda = theta(7);
tau = theta(8);
gamma = theta(9);
w = theta(10);
mu = theta(11);
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_5(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
V0 = theta(4);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_6(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
p = alpha/beta;
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_7(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
% x = theta(5);
% V0 = con_func(x,1e2,4e4);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_8(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
r = theta(3);
f = theta(4);
k = theta(5);
p = alpha/beta;
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_9(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
r = theta(3);
f = theta(4);
k = theta(5);
V0 = theta(6);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_10(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
delta = theta(6);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_11(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
c = theta(6);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_12(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
c = theta(6);
delta = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_13(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
nu = theta(6);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_14(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
nu = theta(6);
c = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_15(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
nu = theta(6);
delta = theta(7);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_16(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
nu = theta(6);
c = theta(7);
delta = theta(8);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_17(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
k = theta(3);
V0 = theta(4);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_18(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
k = theta(3);
V0 = theta(4);
c = theta(5);
delta = theta(6);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_19(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
V0 = theta(5);
p = alpha/beta;
Y0 = [T0,0,0,0,V0,0,0];
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_20(theta)
theta = abs(theta);   
r = theta(1);
f = theta(2);
w = theta(3);
mu = theta(4);
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_21(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
V0 = theta(5);
r = theta(6);
f = theta(7);
w = theta(8);
mu = theta(9);
p = alpha/beta;
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_22(theta)
theta = abs(theta);   
alpha = theta(1);
s = theta(2);
k = theta(3);
V0 = theta(4);
r = theta(5);
f = theta(6);
w = theta(7);
mu = theta(8);
p = alpha/beta;
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_23(theta)
theta = abs(theta);   
beta = theta(1);
s = theta(2);
k = theta(3);
V0 = theta(4);
r = theta(5);
f = theta(6);
w = theta(7);
mu = theta(8);
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_24(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
k = theta(3);
V0 = theta(4);
r = theta(5);
f = theta(6);
w = theta(7);
mu = theta(8);
p = alpha/beta;
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_25(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
V0 = theta(4);
r = theta(5);
f = theta(6);
w = theta(7);
mu = theta(8);
p = alpha/beta;
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_26(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
r = theta(5);
f = theta(6);
w = theta(7);
mu = theta(8);
p = alpha/beta;
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_27(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
V0 = theta(5);
f = theta(6);
w = theta(7);
mu = theta(8);
p = alpha/beta;
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_28(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
V0 = theta(5);
r = theta(6);
w = theta(7);
mu = theta(8);
p = alpha/beta;
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_29(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
V0 = theta(5);
r = theta(6);
f = theta(7);
mu = theta(8);
p = alpha/beta;
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_30(theta)
theta = abs(theta);   
beta = theta(1);
alpha = theta(2);
s = theta(3);
k = theta(4);
V0 = theta(5);
r = theta(6);
f = theta(7);
w = theta(8);
p = alpha/beta;
err = fit_err_func(b);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function err = odefit_31(theta)
theta = abs(theta);    
beta = theta(1);
alpha = theta(2);
s = theta(3);
tau = theta(4);
V0 = theta(5);
w = theta(6);
mu = theta(7);
p = alpha/beta;
err = fit_err_func(b);

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% Error Function
function [err,res,AIC] = fit_err_func(b)
%% Create time vectors
t1a = [0; t1];
t2a = [0; t2];
t3a = [0; t3];
t4a = [0; t4];
t5a = [0; t5];
t6a = [0; t6];
t8a = [0; t8];

%% Solve differential equation models
if b == 1 || b == 2 || b == 5 || b == 7 || b == 8
sol_1 =  ode45(@(t,Y) IR_2(t,Y,beta,p,delta,c,kappa,s,r,f,k,lambda,tau,gamma,w,mu), t_fine, Y0);  
elseif b == 3 || b == 9 || b == 10
sol_1 =  dde23(@(t,Y,Z) IR(t,Y,Z,beta,p,delta,c,kappa,s,r,f,k,lambda,tau,gamma,w,mu), tau, @(t) history(t,T0,V0),t_fine);
end
sol_2 =  ode45(@(t,Y) IR_2(t,Y,beta,p,delta,c,kappa,s,0,0,0,lambda,tau,gamma,w,mu), t_fine, Y0); 

%% Evaluate healthy mice models
if b == 1 || b == 2 || b == 3 || b == 5 || b == 7 || b == 8 || b == 9
Y1 = deval(sol_1,t1a)';
Y2 = deval(sol_1,t2a)';
Y3 = deval(sol_1,t3a)';
Y4 = deval(sol_1,t4a)';

C1 = Y1(:,5);
C2 = nu*Y2(:,4)/T0;
C3 = Y3(:,7);
C4 = Y4(:,6);

[err1,res1] = err_func(d1,C1([2:length(C1)]),sigma(1),5);
[err2,res2] = err_func(d2,C2([2:length(C2)]),sigma(2),6);
[err3,res3] = err_func(d3,C3([2:length(C3)]),sigma(3),5);
[err4,res4] = err_func(d4,C4([2:length(C4)]),sigma(4),5);

%% Evaluate immunosupressed mice models
elseif b == 4 || b == 6 || b == 10
Y5 = deval(sol_2,t5a)';
Y6 = deval(sol_2,t6a)';
Y8 = deval(sol_2,t8a)';
C5 = Y5(:,5);
C6 = nu*Y6(:,4)/T0;
C8 = Y8(:,6);

[err5,res5] = err_func(d5,C5([2:length(C5)]),1,5);
[err6,res6] = err_func(d6,C6([2:length(C6)]),1,6);
[err8,res8] = err_func(d8,C8([2:length(C8)]),1,5);
end

%% Calculate error and residuals
if b == 1
err = err1 + err2 + err3 + err5 + err6;
res(1,1:length(res1)) = res1;
res(2,1:length(res2)) = res2;
res(3,1:length(res3)) = res3;
res(4,1:length(res5)) = res5;
res(5,1:length(res6)) = res6;

elseif b == 2
err = err4;
res = res4;

elseif b == 3
err = err1 + err2 + err3 + err4 + err5 + err6;
res(1,1:length(res1)) = res1;
res(2,1:length(res2)) = res2;
res(3,1:length(res3)) = res3;
res(4,1:length(res4)) = res4;
res(5,1:length(res5)) = res5;
res(6,1:length(res6)) = res6;

elseif b == 4
err = err5 + err6;  
res(1,1:length(res5)) = res5;
res(2,1:length(res6)) = res6;

elseif b == 5
err = err1 + err2 + err3;
res(1,1:length(res1)) = res1;
res(2,1:length(res2)) = res2;
res(3,1:length(res3)) = res3;

elseif b == 6
err = err5;
res(1,1:length(res5)) = res5;

elseif b == 7
err = err1 + err2;
res(1,1:length(res1)) = res1;
res(2,1:length(res2)) = res2;

elseif b == 8
err = err3 + err4;
res(1,1:length(res3)) = res3;
res(2,1:length(res4)) = res4; 

elseif b == 9
err = err1 + err2 + err3 + err4;
res(1,1:length(res1)) = res1;
res(2,1:length(res2)) = res2;
res(3,1:length(res3)) = res3;
res(4,1:length(res4)) = res4;

elseif b == 10
err = err5 + err6 + err8;  
res(1,1:length(res5)) = res5;
res(2,1:length(res6)) = res6;
res(2,1:length(res8)) = res8;

end

%% Calculate AIC
pm = length(theta_0);
if b == 4
nd = length(t4) + length(t5);
elseif b == 9
nd = length(t1) + length(t2) + length(t3) + length(t4);
else
nd = length_dat_func(dat,5);
end
AIC = nd*log(err/nd) + 2*(pm+1) + (2*(pm+1)*(pm+2))/(nd - pm);

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Stop function if optimisation takes too long
function stop = outfun(~,~,~)
stop = false;
ttoc = toc;
if ttoc > 10
    stop = true;
    disp('Max Time Exceeded')
else
end 
end

%% Function to evaluate model
function Y = Vi_func(t,q)
if q == 1
sol =  ode45(@(t,Y) IR_2(t,Y,beta,p,delta,c,kappa,s,r,f,k,lambda,tau,gamma,w,mu), t, Y0);  
elseif q == 2
sol =  dde23(@(t,Y,Z) IR(t,Y,Z,beta,p,delta,c,kappa,s,r,f,k,lambda,tau,gamma,w,mu), tau, @(t) history(t,T0,V0),t);
elseif q == 3
sol =  ode45(@(t,Y) IR_2(t,Y,beta,p,delta,c,kappa,s,0,0,0,lambda,tau,gamma,w,mu), t, Y0);  
end
Y = deval(sol,t)';
end

%% Constrain Function
function Y = con_func(x,a,b)

Y = a  + ((b-a)/2)*(tanh(x) + 1);

end

end

