n_vec = [2^6,2^7,2^8,2^9,2^10,2^11];
l = length(n_vec);
time_vec = zeros(l,1);
p = 10;


for i = 1:l
    n = n_vec(i);
    m = n;
    p = n
    
    A = test_matrix_fastdecay(m,n);
    tic
    q1 = randn(n,1);
    [Q,H] = arnoldi(A,q1,p);
    time_vec(i) = toc   
end

close all 
plot(n_vec,time_vec); 
shg

function A = test_matrix_fastdecay(m,n)

acc   = 1e-20;  
p     = min([m,n]);
[U,~] = qr(randn(m,p),0);
[V,~] = qr(randn(n,p),0);
ss    = acc.^linspace(0,1,p);
A     = U*diag(ss)*V';

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function A = test_matrix_slowdecay(m,n)

p     = min([m,n]);
[U,~] = qr(randn(m,p),0);
[V,~] = qr(randn(n,p),0);
ss    = 1./(1:p);
A     = U*diag(ss)*V';

end


function [Q,H] = arnoldi(A,q1,p)
%ARNOLDI    Arnoldi iteration
%   [Q,H] = ARNOLDI(A,q1,M) carries out M iterations of the
%   Arnoldi iteration with N-by-N matrix A and starting vector q1
%   (which need not have unit 2-norm).  For M < N it produces
%   an N-by-(M+1) matrix Q with orthonormal columns and an
%   (M+1)-by-M upper Hessenberg matrix H such that
%   A*Q(:,1:M) = Q(:,1:M)*H(1:M,1:M) + H(2M+1,M)*Q(:,M+1)*E_M',
%   where E_M is the M'th column of the M-by-M identity matrix.

n = length(A);
if nargin < 3, p = n; end
q1 = q1/norm(q1);
Q = zeros(n,p); Q(:,1) = q1;
H = zeros(min(p+1,p),n);

for k=1:p
    z = A*Q(:,k);
    for i=1:k
        H(i,k) = Q(:,i)'*z;
        z = z - H(i,k)*Q(:,i);
    end
    if k < n
       H(k+1,k) = norm(z);
       if H(k+1,k) == 0, return, end
       Q(:,k+1) = z/H(k+1,k);
   end
end

end 