function Y_vec = MCMC_sim(theta_vec,tf,t,Theta_s,u)

if u == 1
T0 = 7e9;
elseif u == 2
T0 = 7e9;
kappa = 4; 
elseif u == 3
[beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k,T0,V0] = Theta_func_new(Theta_s);
end

K = size(theta_vec,1);
Y_vec = zeros(K,length(t));
for i = 1:K
theta = theta_vec(i,:);
Y = ode_func(t,theta,u);
Y_vec(i,:) = Y;
end

function Y = ode_func(t,theta,u)
if u == 1
sol =  ode45(@(t,Y) TV(t,Y,theta(1),theta(2),theta(3)), tf, [T0, theta(4)]);     
Y1 = deval(sol,t)';
Y = Y1(:,2);
elseif u == 2
sol = ode45(@(t,Y) TEIV(t,Y,theta(1),theta(3),theta(2),theta(4),kappa),tf, [T0, 0, 0, theta(5)]);
Y1 = deval(sol,t)';
Y = Y1(:,4);    
elseif u == 3
sol = ode45(@(t,Y) IR_new(t,Y,theta(1),theta(2),delta,c,kappa,theta(3),theta(4),theta(5),theta(6),m,gamma,theta(7)), tf, [T0, 0, 0, 0, theta(8), 0, 0]);
Y1 = deval(sol,t)';
Y = Y1(:,5);
end


end

end