function [theta_vec,acc_vec,guess,MLE,xx] = MCMC_Ult_New(dat,M,sigma,sd,tstop,u,Theta_s,prior_vec,d_end,n)

[beta,p,delta,c,kappa,tau,s,f,r,m,gamma,k,T0,V0] = Theta_func_new(Theta_s);

if d_end == 0
    t = dat(:,1);
    guess = prior_vec(1,:);    

else
    
    if  isempty(d_end)
        t = dat(:,1);
        d1 = dat(:,2);  
    else
        [t,d1] = split_data(dat,d_end);
        dat = [t,d1];
    end
    
    if u == 1
    Theta = [4.8370e-06,1.2294e-04,0.6937,7e9,100];
    guess = fit_TV(dat,Theta,1,0,0,0);

    elseif u == 2
    V0 = 4e4; 
    Theta = [2e-06,0.01,2,10,4,7e9,434];
    guess = fit_TEIV(dat,Theta,7,0,0,0);

    elseif u == 3        
    guess = fit_IR_V(dat,Theta_s,1,0,0);    
    end

end

tf = linspace(0,t(length(t)));

%% Initialise 
tstart = tic;
r_old = -eps;
co = 1;
xx = 0;
theta_vec = zeros(1,length(guess));
acc_vec = zeros(1,2);

%% Run Algorithm
while co <= M
if toc(tstart) < tstop
theta = get_par(co,theta_vec);  % get parameters from proposal
L = like_func(theta);           % calculate likelihood
pr = calc_prob(theta,L);  % calculate probability

%%%%% Accept/Reject %%%%%%%%%%%%%%%%%%%%%%%%%%
if pr > r_old
   disp_iter(co,500)                % display iteration   
   theta_vec(co,:) = theta; 
   acc_vec(co,:) = [L,pr];
   co = co+1;
   r_old = pr; 
else 
    a = rand;
        if a < pr/r_old
        disp_iter(co,500)                % display iteration     
        theta_vec(co,:) = theta; 
        acc_vec(co,:) = [L,pr];
        co = co+1;
        r_old = pr; 
        else
        xx = xx + 1;    
       end
end 
else
    break
end
end

MLE = MLE_func(theta_vec,acc_vec);

%% Display Iteration 
function disp_iter(i,A)
    
if floor(i/A) == i/A
        disp(i)
end

end

%% Get Parameters %%%%%%%%%%%%%%%%%%%%%
function [theta] = get_par(co,theta_vec)

l = size(theta_vec,2); 
if co == 1        
    theta = guess;
else            
    for j = 1:l
    theta_log(j) = normrnd(log10(theta_vec(co-1,j)),sd(j));
    end
    theta = 10.^theta_log; 
end  

end

%% Likelihood Function %%%%%%%%%%%%%%%%%%%%%
function L = like_func(theta)    
    
   
if d_end ~= 0 
% disp('A')    
if u == 1
sol =  ode45(@(t,Y) TV(t,Y,theta(1),theta(2),theta(3)), tf, [T0, theta(4)]);     
Y1 = deval(sol,t)';
Y = Y1(:,2);
elseif u == 2
sol = ode45(@(t,Y) TEIV(t,Y,theta(1),theta(3),theta(2),theta(4),kappa),tf, [T0, 0, 0, theta(5)]);
Y1 = deval(sol,t)';
Y = Y1(:,4);    
elseif u == 3
sol = ode45(@(t,Y) IR_new(t,Y,theta(1),theta(2),delta,c,kappa,theta(3),theta(4),theta(5),theta(6),m,gamma,theta(7)), tf, [T0, 0, 0, 0, theta(8), 0, 0]);
Y1 = deval(sol,t)';
Y = Y1(:,5);
end
[~,~,L] = Likelihood(d1,Y,sigma,2);

elseif isempty(d_end)
% disp('B')    
if u == 1
sol =  ode45(@(t,Y) TV(t,Y,theta(1),theta(2),theta(3)), tf, [T0, theta(4)]);     
Y1 = deval(sol,t)';
Y = Y1(:,2);
elseif u == 2
sol = ode45(@(t,Y) TEIV(t,Y,theta(1),theta(3),theta(2),theta(4),kappa),tf, [T0, 0, 0, theta(5)]);
Y1 = deval(sol,t)';
Y = Y1(:,4);    
elseif u == 3
sol = ode45(@(t,Y) IR_new(t,Y,theta(1),theta(2),delta,c,kappa,theta(3),theta(4),theta(5),theta(6),m,gamma,theta(7)), tf, [T0, 0, 0, 0, theta(8), 0, 0]);
Y1 = deval(sol,t)';
Y = Y1(:,5);
end
[~,~,L] = Likelihood(d1,Y,sigma,2); 
    
else    
% disp('C')    
L = 1;
end

end

%% Remove Burn in Period %%%%%%%%%%%%%%%%%%%%%
function [theta_vec] = burn(theta_vec,bn)
h = floor(length(beta_vec)*bn);
theta_vec([1:h],:) = [];
end


%% Calculate MLE %%%%%%%%%%%%%%%%%%%%%
function MLE = MLE_func(theta_vec,acc_vec)
[~,I] = max(acc_vec(:,1)); 
MLE = theta_vec(I,:);
end

%% Calculate Probabilities Using Priors %%%%%%%%%%%%%%%%%%%%%
% function pr = calc_prob(theta,L)
% 
% l = length(theta);
% Q = zeros(l,1);    
% for j = 1:l
%     if theta(j) >= 0    
%     Q(j) = 1;
%     else
%     Q(j) = 0;
%     end
% end
% pr = L*prod(Q);
% 
% end

%% Calculate Probabilities Using Priors %%%%%%%%%%%%%%%%%%%%%
function pr = calc_prob(theta,L)

if isempty(prior_vec)    
l = length(theta);
Q = zeros(l,1);    
for j = 1:l
    if theta(j) >= 0    
    Q(j) = 1;
    else
    Q(j) = 0;
    end   
end
pr = L*prod(Q);

else
aa = prior(theta,prior_vec,n);
pr = L*prior(theta,prior_vec,n);
end

end

end


