%% Generate prior gamma distributions for N and beta for the 1G and 2G models

sc1 = 5;
sc2 = 5;
M = 1e6;
s = 50;
l = 500;

[N1_m, beta1_m] = par_func1;
[N2_m, beta2_m] = par_func2;

var_N1 = sc1*1e13;
var_beta1 = sc1*5e-3; 
var_N2 = sc2*1e13;
var_beta2 = sc2*5e-3; 

X1 = linspace(1e7,7e7,l);
X2 = linspace(1.2,2.4,l);
X = [X1;X2;X1;X2];
Y = zeros(4,l);

[N_vec_1,Y(1,:)] = func(N1_m,var_N1,M,s,X1);
[beta_vec_1,Y(2,:)] = func(beta1_m,var_beta1,M,s,X2);
[N_vec_2,Y(3,:)] = func(N2_m,var_N1,M,s,X1);
[beta_vec_2,Y(4,:)] = func(beta2_m,var_beta1,M,s,X2);
line_colour = {'b','b','r','r'};
model_name = {'$N$','$\beta$','$N$','$\beta$'};

close all
for z = 1:4
figure
plot(X(z,:),Y(z,:)/max(Y(z,:)),char(line_colour(z)),'linewidth',1.5)
xlabel(char(model_name(z)),'Fontsize',22)
ylabel('Normalized Probability Density Function','Fontsize',19)
end    

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
function [vec,Y] = func(mu,v,M,s,X)

k = (mu^2)/v;
theta = v/mu;
Y = gampdf(X,k,theta);
R = gamrnd(k,theta,M,1);
R = sort(R);
vec = zeros(s,1);

for i = 1:M
    if floor(i/(M/s)) == i/(M/s)
        vec(i/(M/s)) = R(i - M/(2*s));
    end
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 
% close all
% %% 1-Group N %%%%%%%%%%%%%%%%%%%%%%%%%
% figure
% X = linspace(1e7,7e7,500);
% var_1N = var_N;
% k = (N1_m^2)/var_1N;
% theta = var_1N/N1_m;
% Y = gampdf(X,k,theta);
% plot(X,Y/max(Y),'b','linewidth',1.5)
% xlabel('Effective Population Size $N$','Fontsize',22)
% ylabel('Normalized Probability Density Function','Fontsize',19)
% xlim([1e7 7e7])
% 
% R = gamrnd(k,theta,M,1);
% R = sort(R);
% N_vec_1 = zeros(s,1);
% 
% for i = 1:M
%     if floor(i/(M/s)) == i/(M/s)
%         N_vec_1(i/(M/s)) = R(i - M/(2*s));
%     end
% end
% 
% 
% %% 1-Group beta %%%%%%%%%%%%%%%%%%%%%%%%%
% figure
% X = linspace(1.2,2.4,500);
% var_1b = var_beta;
% k = (beta1_m^2)/var_1b;
% theta = var_1b/beta1_m;
% Y = gampdf(X,k,theta);
% plot(X,Y/max(Y),'b','linewidth',1.5)
% xlabel('Transmissions Rate $\beta$','Fontsize',22)
% ylabel('Normalized Probability Density Function','Fontsize',19)
% xlim([1.2 2.4])
% 
% R = gamrnd(k,theta,M,1);
% R = sort(R);
% beta_vec_1 = zeros(s,1);
% 
% for i = 1:M
%     if floor(i/(M/s)) == i/(M/s)
%         beta_vec_1(i/(M/s)) = R(i - M/(2*s));
%     end
% end
% 
% 
% %% 2-Group N %%%%%%%%%%%%%%%%%%%%%%%%%
% figure
% X = linspace(1e7,7e7,500);
% var_2N = var_N;
% k = (N2_m^2)/var_2N;
% theta = var_2N/N2_m;
% Y = gampdf(X,k,theta);
% plot(X,Y/max(Y),'r','linewidth',1.5)
% xlabel('Effective Population Size $N$','Fontsize',22)
% ylabel('Normalized Probability Density Function','Fontsize',19)
% xlim([1e7 7e7])
% 
% R = gamrnd(k,theta,M,1);
% R = sort(R);
% N_vec_2 = zeros(s,1);
% 
% for i = 1:M
%     if floor(i/(M/s)) == i/(M/s)
%         N_vec_2(i/(M/s)) = R(i - M/(2*s));
%     end
% end
% 
% 
% 
% %% 2-Group beta %%%%%%%%%%%%%%%%%%%%%%%%%
% figure
% X = linspace(1.2,2.4,500);
% 
% [beta_vec_2,Y] = func(beta2_m,var_beta,M,s,X);
% plot(X,Y/max(Y),'r','linewidth',1.5)
% xlabel('Transmissions Rate $\beta$','Fontsize',22)
% ylabel('Normalized Probability Density Function','Fontsize',19)
% xlim([1.2 2.4])
% 
% var_2b = var_beta;
% k = (beta2_m^2)/var_2b;
% theta = var_2b/beta2_m;
% Y = gampdf(X,k,theta);
% plot(X,Y/max(Y),'r','linewidth',1.5)
% xlabel('Transmissions Rate $\beta$','Fontsize',22)
% ylabel('Normalized Probability Density Function','Fontsize',19)
% xlim([1.2 2.4])
% shg
% 
% R = gamrnd(k,theta,M,1);
% R = sort(R);
% beta_vec_2 = zeros(s,1);
% 
% for i = 1:M
%     if floor(i/(M/s)) == i/(M/s)
%         beta_vec_2(i/(M/s)) = R(i - M/(2*s));
%     end
% end
% 
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% 
