%% Generate posterior gamma distributions for N and beta for the 1G and 2G models
load('Results/x10_sim50000.mat')

sc1 = 1;
sc2 = 1;
Q1 = 5;
Q2 = 5;
bin_N = 2.5e5;
bin_beta = 0.005;

[beta_vec_1,N_vec_1,beta_vec_2,N_vec_2] = remove(beta_vec_1,N_vec_1,beta_vec_2,N_vec_2,128e6,10e6);

%%
[N1_m, beta1_m] = par_func1;
[N2_m, beta2_m] = par_func2;

var_N1 = sc1*1e13;
var_beta1 = sc1*5e-3; 
var_N2 = sc2*1e13;
var_beta2 = sc2*5e-3; 

[N_vec_1] = func(N_vec_1,N1_m,var_N1,bin_N,Q1);
l_N1 = length(N_vec_1)
[beta_vec_1] = func(beta_vec_1,beta1_m,var_beta1,bin_beta,Q2);
l_beta1 = length(beta_vec_1)
[N_vec_2] = func(N_vec_2,N2_m,var_N2,bin_N,Q1);
l_N2 = length(N_vec_2)
[beta_vec_2] = func(beta_vec_2,beta2_m,var_beta2,bin_beta,Q2);
l_beta2 = length(beta_vec_2)

close all
histogram(N_vec_1,'BinWidth',bin_N);
xlabel('$N$ 1-Group','Fontsize',22)
figure
histogram(beta_vec_1,'BinWidth',bin_beta);
xlabel('$\beta$ 1-Group','Fontsize',22)
figure
histogram(N_vec_2,'BinWidth',bin_N);
xlabel('$N$ 2-Group','Fontsize',22)
figure
histogram(beta_vec_2,'BinWidth',bin_beta);
xlabel('$\beta$ 2-Group','Fontsize',22)
shg


function [vec_p] = func(vec,mu,v,bin_w,Q)

h = histogram(vec,'BinWidth',bin_w);
hval = h.Values/max(h.Values);
hbin = h.BinEdges + h.BinWidth/2;
hbin(length(hbin)) = [];

k = (mu^2)/v;
theta = v/mu;
post = hval.*gampdf(hbin,k,theta);
post = post/max(post);

s = 1;
for j = 1:length(post)
    if  round(Q*post(j)) >= 1
    vec_p([s:s+round(Q*post(j))]) = hbin(j);
    s = length(vec_p) + 1;
    end
end

end