%% Sensitivity analysis of 2G model %% 
close all
load('Japan_2009_flu.mat');

[Nt, beta] = par_func2(1);
nu = 0.3149;
ti = [0:40];
d1 = dat(:,2);
N = Nt*[nu,1-nu];
C0a = dat(1,2);
C0b = (nu/(1-nu))*C0a;
Y0 = IC2(C0a,N,7/4,[7/3,7/7],0);
inc = 1;

kappa_vec = [7/2,7/3,7/4,7/5,7/6];
mu1_vec = [7/1,7/2,7/3,7/4,7/5];
mu2_vec = [7/5,7/6,7/7,7/8,7/9];
mu2 = 7/7;
l0 = length(kappa_vec);
l1 = length(mu1_vec);
l2 = length(mu2_vec);

%%%%%%%%%%% vary kappa %%%%%%%%%%%

for i0 = 1:l0
kappa = kappa_vec(i0);
mu = [7/3,7/7];
Ca = dis_cases_2(N,beta,mu,kappa,ti,Y0,0,1,C0a);
hold on
plot(ti,Ca,'Linewidth',1.5);
xlabel('Time (Weeks)','FontSize',22)
ylabel('Number of Cases','FontSize',22)
box on
end
legend({'1/$\kappa$=2 days','1/$\kappa$=3 days','1/$\kappa$=4 days','1/$\kappa$=5 days','1/$\kappa$=6 days'},'FontSize',16);
ylim([0 3.2e6])

%%%%%%%%%%% vary mu1 %%%%%%%%%%%

figure
for i1 = 1:l1
kappa = 7/4;
mu1 = mu1_vec(i1);
mu = [mu1,7/7];
Ca = dis_cases_2(N,beta,mu,kappa,ti,Y0,0,1,C0a);
hold on
plot(ti,Ca,'Linewidth',1.5);
xlabel('Time (Weeks)','FontSize',22)
ylabel('Number of Cases','FontSize',22)
box on
end
legend({'1/$\mu_I$=1 days','1/$\mu_I$=2 days','1/$\mu_I$=3 days','1/$\mu_I$=4 days','1/$\mu_I$=5 days'},'FontSize',16);
ylim([0 3.2e6])

%%%%%%%%%%% vary mu2 %%%%%%%%%%%

figure
for i2 = 1:l2
kappa = 7/4;
mu2 = mu2_vec(i2);
mu = [7/3,mu2];
Ca = dis_cases_2(N,beta,mu,kappa,ti,Y0,0,1,C0a);
hold on
plot(ti,Ca,'Linewidth',1.5);
xlabel('Time (Weeks)','FontSize',22)
ylabel('Number of Cases','FontSize',22)
box on
end
legend({'1/$\mu_N$=5 days','1/$\mu_N$=6 days','1/$\mu_N$=7 days','1/$\mu_N$=8 days','1/$\mu_N$=9 days'},'FontSize',16);
ylim([0 3.2e6])


