%% Sensitivity analysis of 2G model %% 
close all
load('Japan_2009_flu.mat');

[N, beta] = par_func1();
nu = 0.3149;
ti = [0:40];
d1 = dat(:,2);
C0a = dat(1,2);
Y0 = IC1(C0a,N,7/4,7/7,0);
inc = 1;

kappa_vec = [7/2,7/3,7/4,7/5,7/6];
mu_vec = [7/5,7/6,7/7,7/8,7/9];
l0 = length(kappa_vec);
l1 = length(mu_vec);


%%%%%%%%%%% vary kappa %%%%%%%%%%%

for i0 = 1:l0
kappa = kappa_vec(i0);
mu = 7/7;
Ca = dis_cases_1(N,beta,mu,kappa,ti,Y0,0,1,C0a);
hold on
plot(ti,Ca,'Linewidth',1.5);
xlabel('Time (Weeks)','FontSize',22)
ylabel('Number of Cases','FontSize',22)
box on
end
legend({'1/$\kappa$=2 days','1/$\kappa$=3 days','1/$\kappa$=4 days','1/$\kappa$=5 days','1/$\kappa$=6 days'},'FontSize',16);
ylim([0 3.2e6])

%%%%%%%%%%% vary mu %%%%%%%%%%%

figure
for i1 = 1:l1
kappa = 7/4;
mu = mu_vec(i1);
Ca = dis_cases_1(N,beta,mu,kappa,ti,Y0,0,1,C0a);
hold on
plot(ti,Ca,'Linewidth',1.5);
xlabel('Time (Weeks)','FontSize',22)
ylabel('Number of Cases','FontSize',22)
box on
end
legend({'1/$\mu$=5 days','1/$\mu$=6 days','1/$\mu$=7 days','1/$\mu$=8 days','1/$\mu$=9 days'},'FontSize',16);
ylim([0 3.2e6])





