%% Plot total cases in 2G model %% 

load('Japan_2009_flu.mat');

[Nt, beta] = par_func2(1);
nu = 0.3149;
ti = dat(:,1);
d1 = dat(:,2);
N = Nt*[nu,1-nu];
mu = [7/3,7/7];
kappa = 7/4;
C0a = dat(1,2);
C0b = (nu/(1-nu))*C0a;
Y0 = IC2(C0a,N,kappa,mu,0);
inc = 1;

Ca = dis_cases_2a(N,beta,mu,kappa,ti,Y0,0,1,C0a);
Cb = dis_cases_2b(N,beta,mu,kappa,ti,Y0,0,1,C0b);

close all
hold on
p2 = plot(ti,Ca,'r','Linewidth',1.5);
p3 = plot(ti,Cb,'r--','Linewidth',1.5);
p4 = plot(ti,Ca+Cb,'r-.','Linewidth',1.5);
p1 = scatter(ti,d1,30,'k','filled');
xlabel('Time (Weeks)','FontSize',22)
ylabel('New Cases','FontSize',22)
legend([p1 p2 p3 p4],{'Data','(Recorded) Naive','(Unrecorded) Immune','Total'},'FontSize',16);
xlim([0 34])
box on
shg

function [C,t] = dis_cases_2a(N,beta,mu,kappa,ti,Y0,C_min,inc,C0) 
[t,Y] = ode45(@(t,Y) SEIR2(t,Y,N,beta,mu,kappa), ti, Y0);
Z = kappa*(Y(:,4));
t_max = floor(t(length(t)));
lZ = t_max+1;
C = zeros(lZ,1);
C(1) = C0;
r = 1/inc;
for i = 2:lZ
    C(i) = sum(Z([((i-2)*r+2):((i-1)*r+1)]))/r;
end
C(C<C_min) = [];
lC = length(C);
t = [0:lC-1];
end

function [C,t] = dis_cases_2b(N,beta,mu,kappa,ti,Y0,C_min,inc,C0) 
[t,Y] = ode45(@(t,Y) SEIR2(t,Y,N,beta,mu,kappa), ti, Y0);
Z = kappa*(Y(:,3));
t_max = floor(t(length(t)));
lZ = t_max+1;
C = zeros(lZ,1);
C(1) = C0;
r = 1/inc;
for i = 2:lZ
    C(i) = sum(Z([((i-2)*r+2):((i-1)*r+1)]))/r;
end
C(C<C_min) = [];
lC = length(C);
t = [0:lC-1];
end
