function [beta_vec_c,N_vec_c,r_vec,L_vec] = MCMC_v2(dat_f,x,gr,nu,dist,p,gam_p,M,r_norm,z,sigma,sd)

mu1G = 7/7;
mu2G = [7/3,7/7];
kappa = 7/4;
dat = dat_f([1:x+1],:);
ti = dat(:,1);
d1 = dat(:,2);
C0 = d1(1);

r_old = 0;
c = 1;
 
for i = 1:M
    if floor(i/1e4) == i/1e4
        disp(i)
    end
   
   if c == 1        
    [beta,N] = first_guess(dist);
   else            
    beta = normrnd(beta_vec(c-1),sd(1));
    N = normrnd(N_vec(c-1),sd(2));
   end
   
   L = like_func(gr,beta,N);                  % calculate likelihood
   r = calc_prob(beta,N,L,dist)/r_norm;  % calculate probability
   L_vec(i) = L;
   r_vec(i) = r;
    
   if r > r_old
   beta_vec(c) = beta; %#ok<*AGROW>
   N_vec(c) = N;
   r_vec(c) = r;
   c = c+1;
   r_old = r; 
   else 
       a = rand;
        if a < r/r_old
        beta_vec(c) = beta;
        N_vec(c) = N;
        r_vec(c) = r;
        c = c+1;
        r_old = r; 
       end
   end   
   
end

%% Remove Burn in Period
h = floor(length(beta_vec)/5);
beta_vec([1:h]) = [];
N_vec([1:h]) = [];

if c == 1
beta_vec_c = 0;
N_vec_c= 0;
else
[beta_vec_c,N_vec_c] = thin_func(beta_vec,N_vec);
max_L = max(L_vec);
max_r = max(r_vec);
end

%% Thin Samples %%%%%%%%%%%%%%%%%%%%%
function [beta_vec_c,N_vec_c] = thin_func(beta_vec,N_vec)
lb = length(beta_vec);
d = floor(lb/z)-1;
beta_vec_c = zeros(d,1);
N_vec_c = zeros(d,1);
for j = 1:d
    beta_vec_c(j) = beta_vec(z*j);
    N_vec_c(j) = N_vec(z*j);
end
end

%% Calculate Probabilities %%%%%%%%%
function r = calc_prob(beta,N,L,dist)

if dist == 1 % Uniform Prior
   if beta >= p(1,1) && beta <= p(1,2) && ...
      N >= p(2,1) && N <= p(2,2)
      r = L;
   else
      r = 0;
   end

elseif dist == 2 % gamma prior 
    p_beta = mygampdf(beta,gam_p(1,1),gam_p(1,2))/6;
    p_N = mygampdf(N,gam_p(2,1),gam_p(2,2))/(1.5e-7);
    r = L*p_beta*p_N;    
end

end

%% First Guess %%%%%%%%%
function [beta,N] = first_guess(dist)
if dist == 1 % Uniform Prior
    [beta,N] = uni_rand(p);
    elseif dist == 2 % Gamma Prior
    [beta,N] = gam_rand(gam_p);
end  
end

%% Likelihood Function 
function L = like_func(gr,beta,N)       
   
if x > 0    
if beta <= 0 || N <= 0
        L = 0;
   else    
   if gr == 1 % 1-Group Model
   Y0 = IC1(d1,N,kappa,mu1G,0); 
   [C,~] = dis_cases_1(N,beta,mu1G,kappa,ti,Y0,0,1,C0);   
   elseif gr == 2 % 2-Group Model
   N_2G = N*[nu,1-nu];
   Y0 = IC2(d1,N_2G,kappa,mu2G,0); 
   [C,~] = dis_cases_2(N_2G,beta,mu2G,kappa,ti,Y0,0,1,C0); 
   end    
   [~,~,L] = err_func_MCMC(dat(:,2),C,3,sigma);
end

else 
L = 1;
end
    
end

%% Sample From Gamma Distribution 
function [beta,N] = gam_rand(gam_p)
mu = gam_p(1,1);
v = gam_p(1,2);
k = (mu^2)/v;
theta = v/mu;
beta = gamrnd(k,theta);
mu = gam_p(2,1);
v = gam_p(2,2);
k = (mu^2)/v;
theta = v/mu;
N = gamrnd(k,theta);
end

%% Sample From Uniform Distribution 
function [beta,N] = uni_rand(p)
beta = p(1,1) + (p(1,2)-p(1,1))*rand; 
N = p(2,1) + (p(2,2)-p(2,1))*rand;   
end

%% My gamma pdf
function prob = mygampdf(X,mu,v)
k = (mu^2)/v;
theta = v/mu;
prob = gampdf(X,k,theta);
end

end