
%% Parameters 
load('Japan_2009_flu.mat');
K = 100;
x = length(dat);
mu = 7/7;
kappa = 7/4;
C0 = dat(1,2);
sigma = 120;
ti = dat(:,1);
d1 = dat(:,2);

% M = 10e4;
M = 5e4;
p1 = [1.5,1.7];
p2 = [2.5e7,3.5e7];

%%
% N = 3.063e7;
% beta = 1.644;
% Y0 = IC1(d1(1),N,kappa,mu,0); 
% [C,t] = dis_cases_1(N,beta,mu,kappa,ti,Y0,0,1,C0);
% [~,~,r] = err_func_MCMC(dat(:,2),C,3,sigma);
% r = r/3e-8;
% plot(t,C)
% shg

%% MCMC

r_old = 0.01;
c = 1;
ca = 0;
tic
for i = 1:M
    if floor(i/1e4) == i/1e4
        disp(i)
   end
   beta = p1(1) + (p1(2)-p1(1))*rand;
   N = p2(1) + (p2(2)-p2(1))*rand;
   Y0 = IC1(d1(1),N,kappa,mu,0); 
   [C,t] = dis_cases_1(N,beta,mu,kappa,ti,Y0,0,1,C0);
   [~,~,r] = err_func_MCMC(dat(:,2),C,3,sigma);
   r = r/3e-8;
   
   if r > r_old
   beta_vec(c) = beta;
   N_vec(c) = N;
   r_vec(c) = r;
   c = c+1;  
   r_old = r; 
   else 
       a = rand;
       if a < r/r_old
        ca = ca + 1;
        beta_vec(c) = beta;
        N_vec(c) = N;
        r_vec(c) = r;
        c = c+1;
        r_old = r; 
       end
   end           

end
toc

%% Plot MCMC Values
close all
plot([1:length(beta_vec)],beta_vec)
figure
plot([1:length(N_vec)],N_vec)
figure
scatter([1:length(r_vec)],r_vec)

%% Remove Burn in Period
b = 6500;
beta_vec([1:b]) = [];
N_vec([1:b]) = [];

%% Thin Parameter Values
lb = length(beta_vec);
z = 1;
d = floor(lb/z)-1;
beta_vec_c = zeros(d,1);
N_vec_c = zeros(d,1);
for j = 1:d
    beta_vec_c(j) = beta_vec(z*j);
    N_vec_c(j) = N_vec(z*j);
end


%% Plot Histogram and Scatter
close all
histogram(beta_vec_c)
figure
histogram(N_vec_c)
figure
scatter(N_vec_c,beta_vec_c,10,'filled','k');
% xlim([2.8e7, 5e7])
% ylim([1.62, 1.74])

%%
figure
for j = 1:d
    beta = beta_vec_c(j);
    N = N_vec_c(j);
    Y0 = IC1(d1(1),N,kappa,mu,0); 
    [C,t] = dis_cases_1(N,beta,mu,kappa,ti,Y0,0,1,C0);
    hold on
    plot(t,C,'c','linewidth',0.5);
end
   
scatter(ti,d1,50,'filled','k');
