function [beta_vec_c,N_vec_c] = MCMC(dat_f,x,gr,nu,dist,p,gam_p,M,r_norm,z,sigma)

mu1G = 7/7;
mu2G = [7/3,7/7];
kappa = 7/4;
dat = dat_f([1:x+1],:);
ti = dat(:,1);
d1 = dat(:,2);
C0 = d1(1);

r_old = 0.01;
c = 1;
for i = 1:M
    if floor(i/1e4) == i/1e4
        disp(i)
    end
   
   if dist == 1 % Uniform Prior
   [beta,N] = uni_rand(p);
   elseif dist == 2 % Gamma Prior
   [beta,N] = gam_rand(gam_p);
   end
   N_2G = N*[nu,1-nu];
   
   if gr == 1 % 1-Group Model
   Y0 = IC1(d1,N,kappa,mu1G,0); 
   [C,~] = dis_cases_1(N,beta,mu1G,kappa,ti,Y0,0,1,C0);
   
   elseif gr == 2 % 2-Group Model
   Y0 = IC2(d1,N_2G,kappa,mu2G,0); 
   [C,~] = dis_cases_2(N_2G,beta,mu2G,kappa,ti,Y0,0,1,C0); 
   end 
   
   [~,~,r] = err_func_MCMC(dat(:,2),C,3,sigma);
   r = r/r_norm;
   if r > r_old
   beta_vec(c) = beta; %#ok<*AGROW>
   N_vec(c) = N;
   r_vec(c) = r;
   c = c+1;   
   r_old = r; 
   else 
       a = rand;
        if a < r/r_old
        beta_vec(c) = beta;
        N_vec(c) = N;
        r_vec(c) = r;
        c = c+1;
        r_old = r; 
       end
   end   
   
end

%% Thin Samples %%%%%%%%%%%%%%%%%%%%%
d = floor(c/z)-1;
beta_vec_c = zeros(d,1);
N_vec_c = zeros(d,1);
for j = 1:d
    beta_vec_c(j) = beta_vec(z*j);
    N_vec_c(j) = N_vec(z*j);
end

end


%% Sample From Gamma Distribution 
function [beta,N] = gam_rand(gam_p)
mu = gam_p(1,1);
v = gam_p(1,2);
k = (mu^2)/v;
theta = v/mu;
beta = gamrnd(k,theta);
mu = gam_p(2,1);
v = gam_p(2,2);
k = (mu^2)/v;
theta = v/mu;
N = gamrnd(k,theta);
end

%% Sample From Uniform Distribution 
function [beta,N] = uni_rand(p)
beta = p(1,1) + (p(1,2)-p(1,1))*rand; 
N = p(2,1) + (p(2,2)-p(2,1))*rand;   
end

