%% Load Data and Default Parameters
load('Japan_2009_flu.mat');
ti = dat(:,1);
C0 = dat(1,2);
d2 = dat(:,2);
dat_f = dat;
x = length(dat)-1;
mu1G = 7/7;
mu2G = [7/3,7/7];
kappa = 7/4;

%% MCMC Parameters
gr = 2;
sigma = 120;
M = 1e5;
dist = 1;
% p = [1.8,2.1; 
%       41e6,54e6];
p = [1,3; 
      10e6,100e6];
gam_p = zeros(2);
r_norm = 3e-8;
z = 1;
% nu = 0.3149; % Immune fraction. Vary this when doing sensitivity analysis 
nu = 2*0.3149;

[beta_vec_2,N_vec_2] = MCMC(dat_f,x,gr,nu,dist,p,gam_p,M,r_norm,z,sigma);

%% Plot Simulations 
K = length(beta_vec_2);
lC = size(dat,1);
C_vec_2 = zeros(K,lC);
ci = 95;
for j = 1:K
    beta = beta_vec_2(j);
    N = N_vec_2(j);
    N_2G = N*[nu,1-nu];
    Y0 = IC2(C0,N_2G,kappa,mu2G,0); 
    [C,~] = dis_cases_2(N_2G,beta,mu2G,kappa,ti,Y0,0,1,C0);
    C_vec_2(j,:) = C;
    d1 = C;
    D2(j,1) = err_func_MCMC(d1,d2,3,sigma);
end   

%%%%% Mean Posterior Parameters %%%%%%%%%
    beta = mean(beta_vec_2);
    N = mean(N_vec_2);
    N_2G = N*[nu,1-nu];
    Y0 = IC2(C0,N_2G,kappa,mu2G,0); 
    [C,~] = dis_cases_2(N_2G,beta,mu2G,kappa,ti,Y0,0,1,C0);
    d1 = C;
    D2m = err_func_MCMC(d1,d2,3,sigma); 

[yl,yu,bl,bu,m] = shade(C_vec_2,sigma,ci);
tot = sum(m);
plot_shade(dat(:,1)',yl,yu,bl,bu,2,0);
p2 = plot(ti,m,'r','linewidth',1.5);
load('Japan_2009_flu.mat');
p1 = scatter(dat(:,1),dat(:,2),30,'k','filled');
legend([p1 p2],{'Data','2-Group Model'},'FontSize',18);

%%
DIC2 = 2*mean(D2) - D2m
[beta_CI,beta_m] = conf_int(beta_vec_2,ci);
[N_CI,N_m] = conf_int(N_vec_2,ci);
[R0_CI,R0_m] = conf_int(R0_func(beta_vec_2,mu2G,N_vec_2,nu),ci)
Im0_2G = nu + sum(dat(:,2))/N_m
Nt_s = N_m
beta_s = beta_m

%% Plot Histogram and Scatter
% histogram(beta_vec_1)
% figure
% histogram(N_vec_1)
figure
hold on
scatter(N_vec_2,R0_func(beta_vec_2,mu2G,N_vec_2,nu),7,'k','filled');
scatter(mean(N_vec_2),mean(R0_func(beta_vec_2,mu2G,N_vec_2,nu)),100,'r','filled');
xlabel('Effective Population Size $N$','FontSize',22)
ylabel('Basic Reproduction Number $R_0$','FontSize',22)
box on
shg
xlim([2.7e7, 5.3e7])
ylim([1.56, 1.68])


