%% Load Data and Default Parameters
load('Japan_2009_flu.mat');
ti = dat(:,1);
C0 = dat(1,2);
d2 = dat(:,2);
dat_f = dat;
x = length(dat)-1;
mu1G = 7/7;
mu2G = [7/3,7/7];
kappa = 7/4;

%% MCMC Parameters
gr = 1;
sigma = 120;
% M = 1e5;
M = 1e4;
dist = 1;
p = [1.5,1.7; 
      25e6,35e6];
gam_p = zeros(2);
r_norm = 3e-8;
z = 1;
nu = 0.3149;

[beta_vec_1,N_vec_1] = MCMC(dat_f,x,gr,nu,dist,p,gam_p,M,r_norm,z,sigma);

%% Plot Simulations 
K = length(beta_vec_1);
lC = size(dat,1);
C_vec_1 = zeros(K,lC);
ci = 95;
for j = 1:K
    beta = beta_vec_1(j);
    N = N_vec_1(j);
    Y0 = IC1(C0,N,kappa,mu1G,0); 
    [C,~] = dis_cases_1(N,beta,mu1G,kappa,ti,Y0,0,1,C0);
    C_vec_1(j,:) = C;
    d1 = C;
    D1(j,1) = err_func_MCMC(d1,d2,3,sigma);
end   

%%%%% Mean Posterior Parameters %%%%%%%%%
    beta = mean(beta_vec_1);
    N = mean(N_vec_1);
    Y0 = IC1(C0,N,kappa,mu1G,0); 
    [C,~] = dis_cases_1(N,beta,mu1G,kappa,ti,Y0,0,1,C0);
    d1 = C;
    D1m = err_func_MCMC(d1,d2,3,sigma); 

figure
[yl,yu,bl,bu,m] = shade(C_vec_1,sigma,ci);
plot_shade(dat(:,1)',yl,yu,bl,bu,1,0);
p2 = plot(ti,m,'b','linewidth',1.5);
load('Japan_2009_flu.mat');
p1 = scatter(dat(:,1),dat(:,2),30,'k','filled');
legend([p1 p2],{'Data','1-Group Model'},'FontSize',18);

%%
DIC1 = 2*mean(D1) - D1m
[beta_CI,beta_m] = conf_int(beta_vec_1,ci)
[N_CI,N_m] = conf_int(N_vec_1,ci)
[R0_CI,R0_m] = conf_int(R0_func(beta_vec_1,mu1G,0,0),ci)


%% Plot Histogram and Scatter
% histogram(beta_vec_1)
% figure
% histogram(N_vec_1)
figure
hold on
scatter(N_vec_1,R0_func(beta_vec_1,mu1G,0,0),7,'k','filled');
scatter(3.063e7,1.644,100,'r','filled');
xlabel('Effective Population Size $N$','FontSize',22)
ylabel('Basic Reproduction Number $R_0$','FontSize',22)
box on
shg
xlim([2.7e7, 5.3e7])
ylim([1.56, 1.68])

