function Y0 = IC2(dat,N,kappa,mu,x) 

C_N = dat(1:x+1);
C_I = (N(1)/N(2))*C_N;
A_N = zeros(x+1,1);
A_I = zeros(x+1,1);

for i = 0:x
    A_N(i+1) = (C_N(i+1)/mu(2))*(exp(-mu(2)*(x-i)) - exp(-mu(2)*((x+1)-i)));
    A_I(i+1) = (C_I(i+1)/mu(1))*(exp(-mu(1)*(x-i)) - exp(-mu(1)*((x+1)-i)));
end

I0_N = sum(A_N);
I0_I = sum(A_I);
E0_N = C_N(x+1)/kappa;
E0_I = C_I(x+1)/kappa;
R0_N = sum(C_N-A_N);
R0_I = sum(C_I-A_I);
S0_N = N(2) - (E0_N + I0_N + R0_N);
S0_I = N(1) - (E0_I + I0_I + R0_I);
Y0 = [S0_I, S0_N, E0_I, E0_N, I0_I, I0_N];

end