%% Run simulations on supercomputer to estimate beta and N

% v = 1: fminsearch
% v = 2: fmincon

%%%%%%%%% Parameters %%%%%%%%%%%%%%%%%%%%%%%
x = 20;
K = 100;
n = 25;
v = 1;
ci = 95;

Im0_2G = 0.752;
C0 = 1e4;
C_min = 0.5e4;
kappa = 7/4;
mu2G = [7/3,7/7];
mu1G = 7/7;
ti = 0:1:50;
inc = 1;
f = 3;
col = [1 0 0];

beta_vec_1 = zeros(K,1);
N_vec_1 = zeros(K,1);
beta_vec_2 = zeros(K,1);
N_vec_2 = zeros(K,1);

%%%%%%%%%%% Simulate Clean Data %%%%%%%%%%%%%%%%%%%%%%%%%
nu = Survival(n,Im0_2G);
Nt_s = 4.952e+07;
N = [nu*Nt_s,(1-nu)*Nt_s];
Y0 = IC2(C0,N,kappa,mu2G,0);
beta_s = 1.889;

[C2,t2] = dis_cases_2(N,beta_s,mu2G,kappa,ti,Y0,C_min,inc,C0);

dat = [t2',C2];
lC = length(C2);
two_Total = sum(C2);
C_vec_1 = zeros(K,lC);
C_vec_2 = zeros(K,lC);

%%%%%%%%%%%%%%% Initial Parameter Fit %%%%%%%%%%%%%%%%%%%%%%

%%%%% 2-Group Model %%%%%%%%%%%%%%
[theta,C2] = fit_func_2(dat,Nt_s,N,nu,beta_s,mu2G,kappa,1,0,0,0,0,f,col,x,v,C0);
N2_s = abs(theta(1));
beta2_s = abs(theta(2));

%%%%% 1-Group Model %%%%%%%%%%%%%%
N1t = 2.2851e+07;
beta = 1.608;
[theta,C1] = fit_func(dat,N1t,nu,beta,mu1G,kappa,1,0,0,0,0,f,col,x,v,C0);
N1_s = abs(theta(1));
beta1_s = abs(theta(2));

tic
parfor k = 1:K
    
%%%%%%%%%%% Add Noise to Data %%%%%%%%%%%%%%%%%%%%%%%%%
sigma = 90;
S2 = noisy_data(C2,sigma);
dat_2 = [t2',S2];
S1 = noisy_data(C1,sigma);
dat_1 = [t2',S1];

%%%%%%%%%%% Fit 2G Model %%%%%%%%%%%%%%%%%%%%%%%%%

nu = Survival(n,Im0_2G);
Nt = 4.9517e+07;
N = [nu*Nt,(1-nu)*Nt];
beta = 1.889;

[theta,C] = fit_func_2(dat_2,Nt,N,nu,beta,mu2G,kappa,1,0,0,0,0,f,col,x,v,C0);
N_vec_2(k) = abs(theta(1));
beta_vec_2(k) = abs(theta(2));
C_vec_2(k,:) = C;

%%%%%%%%%%% Fit 1G Model %%%%%%%%%%%%%%%%%%%%%%%%%
N1t = 2.2851e+07;
beta = 1.608;

[theta,C,t,err,res,one_Total] = fit_func(dat_1,N1t,nu,beta,mu1G,kappa,1,0,0,0,0,f,col,x,v,C0);
N_vec_1(k) = abs(theta(1));
beta_vec_1(k) = abs(theta(2));
C_vec_1(k,:) = C;

end
toc

[beta_vec_1,N_vec_1,beta_vec_2,N_vec_2] = remove(beta_vec_1,N_vec_1,beta_vec_2,N_vec_2,128e6,10e6);
save([pwd '/Results/x',num2str(x),'_sim',num2str(K)],'beta_vec_1','N_vec_1','beta_vec_2','N_vec_2')


