%% Make forecasts with no prior

% v = 1: fminsearch
% v = 2: fmincon

%%%%%%%%% Parameters %%%%%%%%%%%%%%%%%%%%%%%
x = 30;
K = 200;
n = 25;
v = 1;
ci = 95;

[Nt_s, beta_s, Im0_2G] = par_func2();
C0 = 1e4;
C_min = 0;
kappa = 7/4;
mu2G = [7/3,7/7];
mu1G = 7/7;
ti = 0:1:50;
inc = 1;
f = 3;
col = [1 0 0];

beta_vec_1 = zeros(K,1);
N_vec_1 = zeros(K,1);
beta_vec_2 = zeros(K,1);
N_vec_2 = zeros(K,1);

%%%%%%%%%%% Simulate Clean Data %%%%%%%%%%%%%%%%%%%%%%%%%
nu = Survival(n,Im0_2G);
N = [nu*Nt_s,(1-nu)*Nt_s];
Y0 = IC2(C0,N,kappa,mu2G,0);

[C2,t2] = dis_cases_2(N,beta_s,mu2G,kappa,ti,Y0,C_min,inc,C0);

dat = [t2',C2];
lC = length(C2);
two_Total = sum(C2);
C_vec_1 = zeros(K,lC);
C_vec_2 = zeros(K,lC);

%%%%%%%%%%%%%%% Initial Parameter Fit %%%%%%%%%%%%%%%%%%%%%%

%%%%% 2-Group Model %%%%%%%%%%%%%%
[theta,C2,~,~,~,~,L2G] = fit_func_2(dat,Nt_s,N,nu,beta_s,mu2G,kappa,1,0,0,0,0,f,col,x,v,C0);
N2_s = abs(theta(1));
beta2_s = abs(theta(2));
L2G

%%%%% 1-Group Model %%%%%%%%%%%%%%
N1t = 2.2851e+07;
beta = 1.608;
[theta,C1,~,err,~,~,L1G] = fit_func(dat,N1t,nu,beta,mu1G,kappa,1,0,0,0,0,f,col,x,v,C0);
N1_s = abs(theta(1));
beta1_s = abs(theta(2));
L1G

%%
tic
for k = 1:K
    f = 3;
    if rem(k/10,1)==0
        k
    end
    
%%%%%%%%%%% Add Noise to Data %%%%%%%%%%%%%%%%%%%%%%%%%
sigma = 90;
S2 = noisy_data(C2,sigma);
dat_2 = [t2',S2];
S1 = noisy_data(C1,sigma);
dat_1 = [t2',S1];

%%%%%%%%%%% Fit 2G Model %%%%%%%%%%%%%%%%%%%%%%%%%

nu = Survival(n,Im0_2G);
Nt = 4.9517e+07;
N = [nu*Nt,(1-nu)*Nt];
beta = 1.889;

[theta,C] = fit_func_2(dat_2,Nt,N,nu,beta,mu2G,kappa,1,0,0,0,0,f,col,x,v,C0);
N_vec_2(k) = abs(theta(1));
beta_vec_2(k) = abs(theta(2));
C_vec_2(k,:) = C;

%%%%%%%%%%% Fit 1G Model %%%%%%%%%%%%%%%%%%%%%%%%%
N1t = 2.2851e+07;
beta = 1.608;

[theta,C,t,err,res,one_Total] = fit_func(dat_1,N1t,nu,beta,mu1G,kappa,1,0,0,0,0,f,col,x,v,C0);
N_vec_1(k) = abs(theta(1));
beta_vec_1(k) = abs(theta(2));
C_vec_1(k,:) = C;

end
toc

%%%%%%%%%%% Bootrstrap Simulations %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[beta_vec_1,N_vec_1,beta_vec_2,N_vec_2] = remove(beta_vec_1,N_vec_1,beta_vec_2,N_vec_2,128e6,10e6);
K1 = length(beta_vec_1);
K2 = length(beta_vec_2);

tf = 0:ti(length(ti))-x;
C_vec_1f = zeros(K1,lC-x);
C_vec_2f = zeros(K2,lC-x);
C0 = dat(x+1,2);

for k = 1:K1
    Y01 = IC1(dat(:,2),N_vec_1(k),kappa,mu1G,x); 
    [C_vec_1f(k,:),t] = dis_cases_1(N_vec_1(k),beta_vec_1(k),mu1G,kappa,tf,Y01,-1,inc,C0); 
end


for k = 1:K2
    N = N_vec_2(k)*[nu,1-nu]; 
    Y02 = IC2(dat(:,2),N,kappa,mu2G,x); 
    [C_vec_2f(k,:),t] = dis_cases_2(N_vec_2(k),beta_vec_2(k),mu2G,kappa,tf,Y02,-1,inc,C0); 
end

%% Plot Results %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all
for  z = 2
    
line_colour = {'b','r'};
model_name = {'1-Group Model', '2-Group Model'};
if z == 1
C_vec = C_vec_1;
C_vecf = C_vec_1f;
elseif z == 2
C_vec = C_vec_2;
C_vecf = C_vec_2f;
end

figure
[yl,yu,bl,bu,m] = shade(C_vec(:,[1:x+1]),sigma,ci);
plot_shade(0:x,yl,yu,bl,bu,z,0)
plot(0:x,m,char(line_colour(z)),'linewidth',1.5);
[yl,yu,bl,bu,m] = shade(C_vecf,sigma,ci);
plot_shade(t+x,yl,yu,bl,bu,z,0)
p2 = plot(t+x,m,char(line_colour(z)),'linewidth',1.5);
p1 = scatter(t2([1:x+1]),C2([1:x+1]),30,'k','filled');
p3 = scatter(t2([x+2:length(t2)]),C2([x+2:length(t2)]),30,[100,100,100]/256,'filled');
xline(x,'k--','linewidth',2);
yline(1.2e6,'k','linewidth',1);
ylim([0 1.2e6])
xlim([0 50])
legend([p1 p3 p2],{'Observed Data','Future Data',char(model_name(z))},'FontSize',18);
shg

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% ci = 95;
% [yl,yu,bl,bu,m] = shade(C_vec_2(:,[1:x+1]),sigma,ci);
% plot_shade(0:x,yl,yu,bl,bu,2,0)
% plot(0:x,m,'r','linewidth',1.5);
% [yl,yu,bl,bu,m] = shade(C_vec_2f,sigma,ci);
% plot_shade(t+x,yl,yu,bl,bu,2,0)
% p2 = plot(t+x,m,'r','linewidth',1.5);
% p1 = scatter(t2([1:x]),C2([1:x]),30,'k','filled');
% p3 = scatter(t2([x+1:length(t2)]),C2([x+1:length(t2)]),30,[100,100,100]/256,'filled');
% xline(x,'k--','linewidth',2);
% ylim([0 1.2e6])
% xlim([0 50])
% legend([p1 p3 p2],{'Observed Data','Future Data','2-Group Model'},'FontSize',18);
% shg
% 
% figure
% [yl,yu,bl,bu,m] = shade(C_vec_1(:,[1:x+1]),sigma,ci);
% plot_shade(0:x,yl,yu,bl,bu,1,0)
% plot(0:x,m,'b','linewidth',1.5);
% [yl,yu,bl,bu,m] = shade(C_vec_1f,sigma,ci);
% plot_shade(t+x,yl,yu,bl,bu,1,0)
% p2 = plot(t+x,m,'b','linewidth',1.5);
% p1 = scatter(t2([1:x]),C2([1:x]),30,'k','filled');
% p3 = scatter(t2([x+1:length(t2)]),C2([x+1:length(t2)]),30,[100,100,100]/256,'filled');
% xline(x,'k--','linewidth',2);
% ylim([0 1.2e6])
% xlim([0 50])
% legend([p1 p3 p2],{'Observed Data','Future Data','2-Group Model'},'FontSize',18);
% shg



% %%%%% Sort Results %%%%%%%%%%%%%%%
% Ctot_1 = sum(C_vec_1,2);
% [~,ind] = sort(Ctot_1);
% C_vec_1s = C_vec_1(ind,:);
% Ctot_2 = sum(C_vec_2,2);
% [~,ind] = sort(Ctot_2);
% C_vec_2s = C_vec_2(ind,:);

% %% Plot Mean and CI %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% for z = 1:2
%     if z == 1
%         figure
%         hold on
% M1 = sort(C_vec_1s);
% y1l = M1(lq,:);
% y1u = M1(uq,:);
% b1l = max(y1l - 1.96*sqrt(sigma1*y1l),0);
% b1u = min(y1u + 1.96*sqrt(sigma1*y1u),2*y1u);
% patch([t2 fliplr(t2)], [b1l fliplr(b1u)],col,'Facecolor',[220, 231, 250]/256)
% patch([t2 fliplr(t2)], [y1l fliplr(y1u)],col,'Facecolor',[152, 188, 214]/256)
% p2 = plot(t2,mean(C_vec_1s,1),'b','linewidth',1.5);
%     elseif z == 2
%         figure
%         hold on
% M2 = sort(C_vec_2s);
% y2l = M2(lq,:);
% y2u = M2(uq,:);
% b2l = max(y2l - 1.96*sqrt(sigma1*y2l),0);
% b2u = min(y2u + 1.96*sqrt(sigma1*y2u),2*y2u);
% patch([t2 fliplr(t2)], [b2l fliplr(b2u)],col,'Facecolor',[240, 211, 237]/256)
% patch([t2 fliplr(t2)], [y2l fliplr(y2u)],col,'Facecolor',[214,152,208]/256)
% p2 = plot(t2,mean(C_vec_2s,1),'r','linewidth',1.5);
%     end
% 
% p1 = scatter(t2([1:x]),C2([1:x]),30,'k','filled');
% p3 = scatter(t2([x+1:length(t2)]),C2([x+1:length(t2)]),30,[100,100,100]/256,'filled');
% 
% xlabel('Time (Weeks)','FontSize',22)
% ylabel('Number of Cases','FontSize',22)
% xlim([0 t2(length(t2))])
% ylim([0 1.4e6])
% xline(x-1,'k--','linewidth',2);
% yline(14e5);
% yline(0);
% 
% if z == 1
% legend([p1 p3 p2],{'Observed Data','Future Data','1-Group Model'},'FontSize',18);
% elseif z == 2
% legend([p1 p3 p2],{'Observed Data','Future Data','2-Group Model'},'FontSize',18);
% end
% 
% box on
% shg
% end
% 
% 
% %% Plot Histograms %%%%%%%%%%%%%%%%%
% 
% figure
% hold on
% histogram(beta_vec_1,'Facecolor','b','Normalization','probability')
% xlabel('$\beta$','FontSize',22)
% ylabel('Normalized Freqeuncy','FontSize',24)
% box on
% 
% figure 
% hold on
% histogram(N_vec_1,'Facecolor','b','Normalization','probability')
% xlabel('$N$','FontSize',24)
% ylabel('Normalized Freqeuncy','FontSize',22)
% box on
% shg
% 
% figure
% hold on
% histogram(beta_vec_2,'Facecolor','r','Normalization','probability')
% xline(beta_s,'k--','linewidth',2);
% xlabel('$\beta$','FontSize',22)
% ylabel('Normalized Freqeuncy','FontSize',24)
% box on
% 
% figure 
% hold on
% histogram(N_vec_2,'Facecolor','r','Normalization','probability')
% xline(Nt_s,'k--','linewidth',2);
% xlabel('$N$','FontSize',24)
% ylabel('Normalized Freqeuncy','FontSize',22)
% box on
% shg
% 
% 
% %% Plot All Bootrstrap Simulations %%%%%%%%%%%%%%%
% 
% figure
% for k = 1:K
%     hold on
% % plot(t2,C_vec_1(k,:),'Color',[152, 188, 214]/256,'linewidth',0.1);
% plot(t2,C_vec_2(k,:),'Color',[214,152,208]/256,'linewidth',0.5);
% end
% 
% plot(t2,C2,'k','Linewidth',1.5);
% % plot(t2,C2 + 1.96*(sqrt(sigma*C2)),'k-.','Linewidth',1.5);
% % plot(t2,C2 - 1.96*(sqrt(sigma*C2)),'k-.','Linewidth',1.5);
% 
% xlabel('Time (Weeks)','FontSize',22)
% ylabel('New Recorded Cases','FontSize',22)
% xlim([0 t2(length(t2))])
% ylim([0 1e6])
% xline(x,'k--','linewidth',2);
% box on
% shg
% 
% %% Calculate beta, N Confidence Intervals %%%%%%%%%%%%%%%%%
% beta_sort = sort(beta_vec_1);
% beta_CI_1 = zeros(1,2);
% beta_CI_1(1) = beta_sort(lq);
% beta_CI_1(2) = beta_sort(uq);
% 
% N_sort = sort(N_vec_1);
% N_CI_1 = zeros(1,2);
% N_CI_1(1) = N_sort(lq);
% N_CI_1(2) = N_sort(uq);
% 
% beta_CI_1
% N_CI_1
% 
% beta_sort = sort(beta_vec_2);
% beta_CI_2 = zeros(1,2);
% beta_CI_2(1) = beta_sort(lq);
% beta_CI_2(2) = beta_sort(uq);
% 
% N_sort = sort(N_vec_2);
% N_CI_2 = zeros(1,2);
% N_CI_2(1) = N_sort(lq);
% N_CI_2(2) = N_sort(uq);
% 
% beta_CI_2
% N_CI_2
% 
% %% Calculate Confidence Intervals and Error
% 
% err_1 = zeros(K,1);
% err_2 = zeros(K,1);
% 
% Tot_1 = sort(sum(C_vec_1,2));
% mean_1 = mean(Tot_1)
% lq_1 = Tot_1(lq)
% uq_1 = Tot_1(uq)
% 
% Tot_2 = sort(sum(C_vec_2,2));
% mean_2 = mean(Tot_2)
% lq_2 = Tot_2(lq)
% uq_2 = Tot_2(uq)
% 
% for i = 1:K
%     err_1(i) = abs(Tot_1(i) - sum(C2))/sum(C2);
%     err_2(i) = abs(Tot_2(i) - sum(C2))/sum(C2);
% end
% mean_err_1 = mean(err_1)
% mean_err_2 = mean(err_2)