%% Calculate macro statistics of a future epidemic as simulated by the 1G and 2G models

n_vec = [0:1:100];

kappa = 7/4;
mu2G = [7/3,7/7];
mu1G = 7/7;
ti = 0:0.05:300;
inc = 0.05;
C0 = 1000;
C_min = 1000;

%% Initalise vectors
nl = length(n_vec);
R01_vec = zeros(nl,1);
R02_vec = zeros(nl,1);
tot1_vec = zeros(nl,1);
tot2_vec = zeros(nl,1);
mp1_vec = zeros(nl,1);
mp2_vec = zeros(nl,1);
dur1_vec = zeros(nl,1);
dur2_vec = zeros(nl,1);
tmax1_vec = zeros(nl,1);
tmax2_vec = zeros(nl,1);

%%
tic
for i = 1:nl
    
%%%%%%%%% 2-Group Model %%%%%%%%%%%%%%%%
[Nt, beta, Im0_2G] = par_func2();
nu = Survival(n_vec(i),Im0_2G);
N = [nu*Nt,(1-nu)*Nt];
R02_vec(i) = R0_func(beta,mu2G,N,nu);
Y02 = IC2(C0,N,kappa,mu2G,0);
[C2,t2] = cont_cases_2(N,beta,mu2G,kappa,ti,Y02,C_min,inc,C0);

%%%%%%%%% 1-Group Model %%%%%%%%%%%%%%%%    
[Nt, beta] = par_func1();
R01_vec(i) = R0_func(beta,mu1G,Nt,0);
Y01 = IC1(C0,Nt,kappa,mu1G,0);
[C1,t1] = cont_cases_1(Nt,beta,mu1G,kappa,t2,Y01,0,inc,C0);
[~,t3] = cont_cases_1(Nt,beta,mu1G,kappa,ti,Y01,C_min,inc,C0);

%% Add results to vectors
[tot1_vec(i)] = sum(C1*inc);
[tot2_vec(i)] = sum(C2*inc);
[mp1_vec(i),i1] = max(C1*inc);
[mp2_vec(i),i2] = max(C2*inc);
tmax1_vec(i) = t1(i1);
tmax2_vec(i) = t2(i2);
dur1_vec(i) = t3(length(t3));
dur2_vec(i) = t2(length(t2));


end

%% Plot Results %%%%%%%%%%%%%%%%%%%%%%%%%

figure
hold on
plot(n_vec,Survival(n_vec,Im0_2G),'r','linewidth',1.5)
xlabel('Time After First Epidemic (Years)','Fontsize',22)
ylabel('Partially Immune Fraction $\nu$','Fontsize',22)
box on
% filename = ['Future_Im_Frac'];
% print(gcf,filename,'-depsc')
% saveas(gca,[pwd 'Future_Im_Frac.fig']);

figure
hold on
plot(n_vec,R01_vec,'b','linewidth',1.5)
plot(n_vec,R02_vec,'r','linewidth',1.5)
xlabel('Time After First Epidemic (Years)','Fontsize',22)
ylabel('Basic Reproduction Number $R_0$','Fontsize',22)
legend({'1-Group Model','2-Group Model',},'FontSize',18,'location','northwest');
box on
% filename = ['Future_R0'];
% print(gcf,filename,'-depsc')
% saveas(gca,['Future_R0.fig']);

figure
hold on
plot(n_vec,tot1_vec,'b','linewidth',1.5)
plot(n_vec,tot2_vec,'r','linewidth',1.5)
xlabel('Time After First Epidemic (Years)','Fontsize',22)
ylabel('Total Cases','Fontsize',22)
legend({'1-Group Model','2-Group Model',},'FontSize',18,'location','northwest');
box on
% filename = ['Future_Total'];
% print(gcf,filename,'-depsc')
% saveas(gca,['Future_Total.fig']);

figure
hold on
plot(n_vec,dur1_vec,'b','linewidth',1.5)
plot(n_vec,dur2_vec,'r','linewidth',1.5)
xlabel('Time After First Epidemic (Years)','Fontsize',22)
ylabel('Duration of Epidemic (Weeks)','Fontsize',22)
legend({'1-Group Model','2-Group Model',},'FontSize',18,'location','northeast');
box on
ylim([0 140])
% filename = ['Future_Duration'];
% print(gcf,filename,'-depsc')
% saveas(gca,['Future_Duration.fig']);

figure
hold on
plot(n_vec,mp1_vec,'b','linewidth',1.5)
plot(n_vec,mp2_vec,'r','linewidth',1.5)
xlabel('Time After First Epidemic (Years)','Fontsize',22)
ylabel('Maximum Weekly Number of Cases','Fontsize',22)
legend({'1-Group Model','2-Group Model'},'FontSize',18,'location','northwest');
box on
% filename = ['Future_MP'];
% print(gcf,filename,'-depsc')
% saveas(gca,['Future_MP.fig']);

%%
figure
hold on
plot(n_vec,tmax1_vec,'b','linewidth',1.5)
plot(n_vec,tmax2_vec,'r','linewidth',1.5)
xlabel('Time After First Epidemic (Years)','Fontsize',22)
ylabel('Time of Max Cases (Weeks Since Start)','Fontsize',22)
legend({'1-Group Model','2-Group Model'},'FontSize',18,'location','northeast');
box on
ylim([0 140])
shg
% filename = ['Future_Time_MP'];
% print(gcf,filename,'-depsc')
% saveas(gca,['Future_Time_MP.fig']);

toc
