%% Calculate macro statistics of a future epidemic as simulated by the 1G and 2G models

n_vec = [0:2:100];

R0_1G = 1.6077;
Im0_2G = 0.7343;
Nt = 4.9982e+07;
beta =  1.8886;
kappa = 7/4;
mu = [7/3,7/7];

nl = length(n_vec);
R0_vec = zeros(nl,1);

close all
tic

for i = 1:nl
    
nu = Survival(n_vec(i),Im0_2G);
N = [nu*Nt,(1-nu)*Nt];

J = [(beta/sum(N))*N(1) - mu(1), (beta/sum(N))*N(1);
     (beta/sum(N))*N(2), (beta/sum(N))*N(2) - mu(2)];
[V,D] = eig(J);
eig1 = V(:,2);
eig2 = eig1/sum(eig1);

R0_vec(i) = (beta/mu(1))*eig2(1) +  (beta/mu(2))*eig2(2);

end

%%%%%% Plot Results %%%%%%%%%%%%%%%%%%%%%%%%%

figure
hold on
plot(n_vec,R0_1G*ones(nl,1),'b','linewidth',1.5)
plot(n_vec,R0_vec,'r','linewidth',1.5)
xlabel('Time After First Epidemic (Years)','Fontsize',22)
ylabel('Basic Reproduction Number $R_0$','Fontsize',22)
legend({'1-Group Model','2-Group Model'},'FontSize',18,'location','northwest');
box on
shg


