%% Plots forecasts of a future epidemic in real-time 

close all
%%%%%%%%% Parameters %%%%%%%%%%%%%%%%%%%%%%%
S = 1;
sav = 0;
fig = 5;
n = 25;
x = 30;
dist = 2; % dist = 1: uniform prior, dist = 2: gamma prior
M = 1e4;
sigma = 120;
r_norm = 1;
z = 5;
sd = [0.03,3e6];
ci = 95;
ytop = 3e6;

%%%%%%%%% Uniform Priors %%%%%%%%%%%%%%%%%%%%%%%
if S == 1 || S == 0.5
p = [1,2.2; 
      10e6,128e6];
elseif  S == 2
p = [1,4; 
      10e6,128e6];
end

%%%%%%%%% Gamma Priors %%%%%%%%%%%%%%%%%%%%%%%
sc1 = 0.2;
sc2 = 0.2;
sc = sc1;
var_N1 = sc1*1e13;
var_beta1 = sc1*5e-3; 
var_N2 = sc2*1e13;
var_beta2 = sc2*5e-3; 
[N1_m, beta1_m] = par_func1();
[N2_m, beta2_m] = par_func2(S);
gam_p_1 = [beta1_m, var_beta1; N1_m, var_N1];
gam_p_2 = [beta2_m, var_beta2; N2_m, var_N2];

%% Fixed Parameters
[Nt_s, beta_s, Im0_2G] = par_func2(S);
kappa = 7/4;
mu2G = [7/3,7/7];
mu1G = 7/7;
nu = Survival(n,Im0_2G);
ti = 0:1:50;
ti_a = ti(1:x+1);
ti_b = ti(x+1:length(ti));
tf = 0:ti(length(ti))-x;
inc = 1; 
C0 = 1e4;
C_min = 0;
r_norm1 = 1e-7;

%% Simulate Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

N = [nu*Nt_s,(1-nu)*Nt_s];
Y0 = IC2(C0,N,kappa,mu2G,0);
[C2,t2] = dis_cases_2(N,beta_s,mu2G,kappa,ti,Y0,C_min,inc,C0);
dat_f = [t2',C2];
d2 = C2([x+2:length(t2)]);
C0f = C2(x+1);

%% MCMC %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tic
[beta_vec_1,N_vec_1,r_vec_1,L_vec_1] = MCMC_v2(dat_f,x,1,nu,dist,p,gam_p_1,M,r_norm1,z,sigma,sd);
[beta_vec_2,N_vec_2,r_vec_2,L_vec_2] = MCMC_v2(dat_f,x,2,nu,dist,p,gam_p_2,M,r_norm1,z,sigma,sd);
toc

%% Simulate Models
K1 = length(beta_vec_1);
K2 = length(beta_vec_2);
D1 = length(beta_vec_1);
D2 = length(beta_vec_2);
lC = size(dat_f,1)-x;
C_vec_1a = zeros(K1,length(ti_a));
C_vec_1 = zeros(K1,lC);
C_vec_2a = zeros(K2,length(ti_a));
C_vec_2 = zeros(K2,lC);

%%%%% 1-Group Model %%%%%%%%%%%%%%%%%%%%%%%%%
if x > 0
for j = 1:K1
    beta = beta_vec_1(j);
    N = N_vec_1(j);
    Y0 = IC1(dat_f(:,2),N,kappa,mu1G,0); 
    [C,~] = dis_cases_1(N,beta,mu1G,kappa,ti_a,Y0,0,1,dat_f(1,2));
    C_vec_1a(j,:) = C;
end 
end

for j = 1:K1
    beta = beta_vec_1(j);
    N = N_vec_1(j);
    Y0 = IC1(dat_f(:,2),N,kappa,mu1G,x); 
    [C,~] = dis_cases_1(N,beta,mu1G,kappa,tf,Y0,0,1,C0f);
    C_vec_1(j,:) = C;
    d1 = C([2:length(d2)+1]);
    [D1(j,1)] = err_func_MCMC(d1,d2,3,sigma);
end   

%%%%% Mean Posterior Parameters %%%%%%%%%%%%%%%%%%%%%%%%%
    beta = mean(beta_vec_1);
    N = mean(N_vec_1);
    Y0 = IC1(dat_f(:,2),N,kappa,mu1G,x); 
    [C,~] = dis_cases_1(N,beta,mu1G,kappa,tf,Y0,0,1,C0f);
    d1 = C([2:length(d2)+1]);
    [D1m] = err_func_MCMC(d1,d2,3,sigma); 

%%%%% 2-Group Model %%%%%%%%%%%%%%%%%%%%%%%%%
if x > 0
for j = 1:K2
    beta = beta_vec_2(j);
    N = N_vec_2(j);
    N_2G = N*[nu,1-nu];
    Y0 = IC2(dat_f(:,2),N_2G,kappa,mu2G,0); 
    [C,~] = dis_cases_2(N_2G,beta,mu2G,kappa,ti_a,Y0,0,1,dat_f(1,2));
    C_vec_2a(j,:) = C;
end   
end

for j = 1:K2
    beta = beta_vec_2(j);
    N = N_vec_2(j);
    N_2G = N*[nu,1-nu];
    Y0 = IC2(dat_f(:,2),N_2G,kappa,mu2G,x); 
    [C,~] = dis_cases_2(N_2G,beta,mu2G,kappa,tf,Y0,0,1,C0f);
    C_vec_2(j,:) = C;
    d1 = C([2:length(d2)+1]);
    D2(j,1) = err_func_MCMC(d1,d2,3,sigma);
end  

%%%%% Mean Posterior Parameters %%%%%%%%%%%%%%%%%%%%%%%%%
    beta = mean(beta_vec_2);
    N = mean(N_vec_2);
    N_2G = N*[nu,1-nu];
    Y0 = IC2(dat_f(:,2),N_2G,kappa,mu2G,x); 
    [C,~] = dis_cases_2(N_2G,beta,mu2G,kappa,tf,Y0,0,1,C0f);
    d1 = C([2:length(d2)+1]);
    D2m = err_func_MCMC(d1,d2,3,sigma);

%%%%% DIC %%%%%%%%%%%%%%%%%%%%%%%%%
DIC1 = 2*mean(D1) - D1m
DIC2 = 2*mean(D2) - D2m

%% 1-Group Model Plot

figure
[~,~,~,~,ma] = shade(C_vec_1a,sigma,ci);
[yl,yu,bl,bu,m] = shade(C_vec_1,sigma,ci);
plot_shade(tf+x,yl,yu,bl,bu,1,0);
p = scatter(t2([1:x+1]),C2([1:x+1]),30,'k','filled');
p3 = scatter(t2([x+2:length(t2)]),C2([x+2:length(t2)]),30,[100,100,100]/256,'filled');
plot(ti_a,ma,'b--','linewidth',1.5);
p2 = plot(tf+x,m,'b','linewidth',1.5);
xline(x,'k--','linewidth',2);
yline(ytop,'k','linewidth',1);
ylim([0 ytop])
xlim([0 50])
legend([p p3 p2],{'Observed Data','Future Data','1-Group Model'},'FontSize',18);

if sav == 1
if fig == 3
filename = [pwd '/Figures/Fig_3/MCMC/1G_x',num2str(x)];
saveas(gca,[pwd '/Figures/Fig_3/MCMC/1G_x',num2str(x),'.fig']);
print(gcf,filename,'-depsc')
elseif fig == 5
% filename = [pwd '/Figures/Fig_5/MCMC/1G_x',num2str(x),'_sc',num2str(sc)];
% saveas(gca,[pwd '/Figures/Fig_5/MCMC/1G_x',num2str(x),'_sc',num2str(sc),'.fig']);
filename = ['1G_x',num2str(x),'_sc',num2str(sc),'_dist',num2str(dist),'_S',num2str(S)];
saveas(gca,['1G_x',num2str(x),'_sc',num2str(sc),'_dist',num2str(dist),'_S',num2str(S),'.fig']);
print(gcf,filename,'-depsc')
end
end

%% 2-Group Model Plot
figure
[~,~,~,~,ma] = shade(C_vec_2a,sigma,ci);
[yl,yu,bl,bu,m] = shade(C_vec_2,sigma,ci);
plot_shade(tf+x,yl,yu,bl,bu,2,0);
p = scatter(t2([1:x+1]),C2([1:x+1]),30,'k','filled');
p3 = scatter(t2([x+2:length(t2)]),C2([x+2:length(t2)]),30,[100,100,100]/256,'filled');
plot(ti_a,ma,'r--','linewidth',1.5);
p2 = plot(tf+x,m,'r','linewidth',1.5);
xline(x,'k--','linewidth',2);
yline(ytop,'k','linewidth',1);
ylim([0 ytop])
xlim([0 50])
legend([p p3 p2],{'Observed Data','Future Data','2-Group Model'},'FontSize',18);

if sav == 1
if fig == 3
filename = [pwd '/Figures/Fig_3/MCMC/2G_x',num2str(x)];
saveas(gca,[pwd '/Figures/Fig_3/MCMC/2G_x',num2str(x),'.fig']);
print(gcf,filename,'-depsc')
elseif fig == 5
% filename = [pwd '/Figures/Fig_5/MCMC/2G_x',num2str(x),'_sc',num2str(sc)];
% saveas(gca,[pwd '/Figures/Fig_5/MCMC/2G_x',num2str(x),'_sc',num2str(sc),'.fig']);
filename = ['2G_x',num2str(x),'_sc',num2str(sc),'_dist',num2str(dist),'_S',num2str(S)];
saveas(gca,['2G_x',num2str(x),'_sc',num2str(sc),'_dist',num2str(dist),'_S',num2str(S),'.fig']);
print(gcf,filename,'-depsc')
end
end

