%% Fit the 1 group model to Japan data

%%%%%%%%% Parameters %%%%%%%%%%%%%%%%%%%%%%%
load('Japan_2009_flu.mat');
K = 100;
x = length(dat);
N = 127340884;
N_tot = N;
Im_frac = 0.3149;
beta = 2;
mu = 7/7;
kappa = 7/4;
C0 = dat(1,2);
col = [0 0 1];
ci = 95;

%%%%%%%%% Initial Fit %%%%%%%%%%%%%%%%%%%%%%%
[theta,C,t,err,res] = fit_func(dat,N,Im_frac,beta,mu,kappa,1,0,0,0,0,3,col,x,1,C0);
N_s = abs(theta(1));
beta_s = abs(theta(2));
sigma = sqrt(err/(x-2))
% sigma = mean(abs(res))
AIC_1 = x*log(err/x) + 3;


%% Generate Synthetic Data %%%%%%%%%%%%%%%%%%%%%%%%%%%%

lC = length(C);
S = zeros(lC,K);
for k = 1:K
S(:,k) = noisy_data(C,sigma);
end 

%% Fit Model to Synthetic Data  %%%%%%%%%%%%%%%%%%%%%%%%%%%%

beta_vec_1 = zeros(K,1);
N_vec_1 = zeros(K,1);
C_vec_1 = zeros(K,lC);
AIC_vec_1 = zeros(K,1);

tic
for k = 1:K
    if rem(k/10,1) == 0
        k
    end
    dat = [dat(:,1),S(:,k)];
    [theta,C,~,err] = fit_func(dat,N,Im_frac,beta,mu,kappa,1,0,0,0,0,3,col,x,1,C0);
    N_vec_1(k) = theta(1);
    beta_vec_1(k) = theta(2);
    C_vec_1(k,:) = C;
    AIC_vec_1(k) = x*log(err/x) + 3;
end
toc 
save([pwd '/Results/1G_Japan_K',num2str(K)],'theta','C','t','err','res','sigma','AIC_1','beta_vec_1','N_vec_1')

%% Plot Simulation Results %%%%%%%%%%%%%%%%%%
[yl,yu,bl,bu,m] = shade(C_vec_1,sigma,ci);
plot_shade(dat(:,1)',yl,yu,bl,bu,1,1);
p2 = plot(t,m,'b','linewidth',1.5);
load('Japan_2009_flu.mat');
p1 = scatter(dat(:,1),dat(:,2),30,'k','filled');
legend([p1 p2],{'Data','1-Group Model'},'FontSize',18);

[beta_CI,beta_m] = conf_int(beta_vec_1,ci);
[N_CI,N_m] = conf_int(N_vec_1,ci);
[AIC_CI,AIC_m] = conf_int(AIC_vec_1,ci);


%% R0, N scatter plot %%%%%%%%%%%%
figure 
hold on
scatter(N_vec_1,R0_func(beta_vec_1,mu,0,0),10,'k','filled');
scatter(N_s,R0_func(beta_s,mu,0,0),100,'r','filled');
xlabel('Effective Population Size $N$','FontSize',22)
ylabel('Basic Reproduction Number $R_0$','FontSize',22)
% xlim([2.5e7, 5.5e7])
% ylim([3.5e-8, 5.5e-8])
rho = corr(beta_vec_1,N_vec_1,'type','Spearman');	
box on
shg

%% Plot Residuals %%%%%%%%%%%%
figure
scatter(dat(:,1),res,30,'k','filled');
xlabel('Time (Weeks)','FontSize',22)
ylabel('Residuals','FontSize',22)
box on

figure
scatter(dat(:,2),res,30,'k','filled');
xlabel('Model Value (Cases)','FontSize',22)
ylabel('Residuals','FontSize',22)
box on