function [C,t] = cont_cases_1b(N,beta,mu,kappa,ti,Y0,C_min,inc) 
opt = odeset('Events', @myEvent);
[t,Y] = ode45(@(t,Y) SEIR1(t,Y,N,beta,mu,kappa), ti, Y0, opt);
lt = length(t);
Z = kappa*Y(:,2);
r = 1/inc;
I0 = Y0(3);
Z_hist = [I0*ones(r-1,1);Z];
C = zeros(lt,1);
for i = 1:lt
    C(i) = sum(Z_hist([i:r+i-1]))/r;
end
C(C<C_min) = [];
lC = length(C);
t = t([1:lC]);
end

function [value, isterminal, direction] = myEvent(~,Y)
value      = (Y(3) <= 5);
isterminal = 1;   % Stop the integration
direction  = 1;
end