#!/bin/csh

#
# Basic 2D Phase-Sensitive Processing:
#   Cosine-Bells are used in both dimensions.
#   Use of "ZF -auto" doubles size, then rounds to power of 2.
#   Use of "FT -auto" chooses correct Transform mode.
#   Imaginaries are deleted with "-di" in each dimension.
#   Phase corrections should be inserted by hand.

nmrPipe -in test.fid \
| nmrPipe  -fn SP -off 0.5 -end 1.0 -pow 3 -c 0.5    \
| nmrPipe  -fn ZF -auto                               \
#| nmrPipe  -fn SOL                                    \
| nmrPipe  -fn FT -auto                               \
| nmrPipe  -fn PS -p0 -15.00 -p1 0.00 -di -verb         \
| nmrPipe  -fn EXT -left -sw                              \
| nmrPipe  -fn TP                                     \
| nmrPipe  -fn SP -off 0.5 -end 1.00 -pow 3 -c 0.5    \
| nmrPipe  -fn ZF -auto                               \
| nmrPipe  -fn FT -auto                               \
| nmrPipe  -fn PS -p0 15.70 -p1 0.00 -di -verb         \
   -ov -out WT_7.ft2

pipe2ucsf WT_7.ft2 WT_7.ucsf
