#!/bin/sh
# The next line restarts using nmrWish \
exec nmrWish "$0" -- "$@"

message .msg -relief raised -bg blue -fg white \
 -width 30c -text "Detecting Peaks ..."

pack    .msg
update

set tabName  test.tab
set specName pkROI_1d.dat
set tabCount 1

set tabDir [file dirname $tabName]

if {![file exists $tabDir]} {file mkdir $tabDir}


set thisSpecName $specName
set thisTabName  $tabName

set x1      4
set xN      32765
set xInc    32762
set xExtra  1
set xLast   [expr $xN + $xExtra + 1]

    set xFirst  $x1

while {$xFirst <= 1 + $xN - $xExtra} \
   {
    set xNext [expr $xFirst+$xInc+2*$xExtra-1]
    if {$xNext > $xLast} {set xNext $xLast}

    readROI -roi 1 -ndim 1 -in $thisSpecName \
       -x X_AXIS $xFirst $xNext           \
       -verb

    pkFindROI -roi 1 \
      -sigma 27214.3 -pChi 0.0001 -plus 7.99927e+06 -minus -7.99927e+06 \
      -dx        1 \
      -idx       1 \
      -tol    2.00 \
      -hiAdj  1.20 \
      -lw    15.00 \
      -parent  -sinc -mask -out $thisTabName -verb

    set xFirst [expr 1 + $xNext - 2*$xExtra]
   }


exit
