#!/bin/csh

#
# Basic 2D Phase-Sensitive Processing:
#   Cosine-Bells are used in both dimensions.
#   Use of "ZF -auto" doubles size, then rounds to power of 2.
#   Use of "FT -auto" chooses correct Transform mode.
#   Imaginaries are deleted with "-di" in each dimension.
#   Phase corrections should be inserted by hand.

nmrPipe -in test.fid \
| nmrPipe  -fn SP -off 0.5 -end 1.00 -pow 5 -c 1.0    \
| nmrPipe  -fn ZF -auto                               \
| nmrPipe  -fn FT -auto                               \
| nmrPipe  -fn PS -p0 -40.90 -p1 -5.53 -di -verb         \
| nmrPipe -fn BASE -nl 1.14ppm 0.7ppm -nw 10                                       \
| nmrPipe  -fn EXT -x1 0.68ppm -xn 1.2ppm -sw          \
   -ov -out test.ft2

projer
