#ifndef __LINEAR_FUNCTIONS_INCLUDED__
	#define __LINEAR_FUNCTIONS_INCLUDED__
	#include "parametersAndLibraries.h"
	
	class dCell{//dendritic cell
		public:
			dCell(double entryTime){
				x=-1; y=-1; z=-1;
				vx=0; vy=0; vz=0;//0 velocity
				dx=0; dy=0; dz=0;//destination coordinates
				cogAgRatio=0; probActivation=0; timeAntigenCountLastUpdated=0; entryT=entryTime, timeMovementUpdated=0;
			}
			
			void set_position(double nx, double ny, double nz){
				x=nx; y=ny; z=nz;
			}
			double get_x() const {return x;}
			double get_y() const {return y;}
			double get_z() const {return z;}

			void set_destination(double x, double y, double z){
				dx=x; dy=y; dz=z;
			}
			double get_dest_x() const {return dx;}
			double get_dest_y() const {return dy;}
			double get_dest_z() const {return dz;}

			void set_source(double x, double y, double z){
				sx=x; sy=y; sz=z;
			}
			double get_source_x() const {return sx;}
			double get_source_y() const {return sy;}
			double get_source_z() const {return sz;}

			void set_entry_time(double t) {entryT=t;}
			double get_entry_time() {return entryT;}
			void set_coord_switch_times(vector<double> cst) {coordSwitchTimes=cst;}
			vector<double> get_coord_switch_times() {return coordSwitchTimes;}
			void set_timeMovementUpdated(double t) {timeMovementUpdated=t;}
			double get_timeMovementUpdated() {return timeMovementUpdated;}

			void set_velocity(double nvx, double nvy, double nvz){
				vx=nvx; vy=nvy; vz=nvz;
			}
			double get_vx() const {return vx;}
			double get_vy() const {return vy;}
			double get_vz() const {return vz;}
			vector<double> get_vel() const {return {vx,vy,vz};}

			void set_num_cog_antigen(double t, double cogRatio, double cogPrecision, double *cognateAgProbabilityTable){
				cogAgRatio=cogRatio;
				probActivation=cognateAgProbabilityTable[int(cogRatio/cogPrecision)];
				timeAntigenCountLastUpdated=t;
			}
			double get_cog_antigen_ratio() { return cogAgRatio; }
			double get_probActivation() {return probActivation;}

			int update_num_cog_antigen(uint time, double timeStep, double antigenDecayRate, double cogPrecision, double *cognateAgProbabilityTable){
				cogAgRatio *= exp(-antigenDecayRate*(time-timeAntigenCountLastUpdated)*timeStep); //Exponential decay
				probActivation = cognateAgProbabilityTable[int(cogAgRatio/cogPrecision)];
				timeAntigenCountLastUpdated=time;
				return probActivation<PROBABILITY_TOLERANCE; //Two birds with one stone
			}
			double get_timeAntigenUpdated(){ return timeAntigenCountLastUpdated;}
			void set_timeAntigenUpdated(double t) {timeAntigenCountLastUpdated=t;}

			int cannot_activate_t_cells(){ return probActivation<PROBABILITY_TOLERANCE; }
		private:
			double x,y,z;						//position
			double vx,vy,vz;					//velocity
			double dx,dy,dz;					//destination position
			double sx,sy,sz;					//source position
			double entryT;						//Time the DC entered the LN
			double cogAgRatio, probActivation;	//the number of cognate antigen on this DC, and so the probability it will activate a bound Tcell
			unsigned long int timeAntigenCountLastUpdated, timeMovementUpdated; 	//The last time that this DC's parameters were updated - between then and now, it will have moved & lost some antigen.
			vector<double> coordSwitchTimes;	//The times that a moving DC switches coordinate
	};

	#include "classesAndFunctions.h"

	//Coordinates
		#define DISCRETISE(x) (int(((x)+radius)*contractGridReductionFactor/contactRadius))

	//Interactions
		#define CHECK_CONTACT_WITH_DENDRITES_T(x, y, z, inContact) {																							\
			SET_COORDINATES(x,y,z,coordX,coordY,coordZ);																										\
			nearbyDCs = occupiedPositions[THREED_TO_ONED(coordX,coordY,coordZ)];																				\
			for(auto nbDC: nearbyDCs){																															\
				canActivate=1;/*Will be checked for the moving DCs*/																							\
				if(nbDC<0) {nbDC=-nbDC; UPDATE_POSITION_OF_MOVING_DC(nbDC);}/*this assignment does not change the original vector*/								\
				if(HAS_CONTACTED_DC(tCellNum,nbDC) || !canActivate) continue;/*If the T-cell failed to be activated by this DC just now, stop. If we just found that the moving DC can't activate anything and deleted it, stop.*/\
				dendx=dCellList[nbDC].get_x(); dendy=dCellList[nbDC].get_y(); dendz=dCellList[nbDC].get_z();													\
				if( SQMAGNITUDE(x-dendx,y-dendy,z-dendz) <= contactRadius*contactRadius) {dCellNum=nbDC; inContact=1; break;}/*activate T-cell and leave loop.*/\
			}																																					\
		}
		#define CHECK_CONTACT_WITH_DENDRITES_DC(x, y, z, inContact) {															\
			SET_COORDINATES(x,y,z,coordX,coordY,coordZ);																		\
			nearbyDCs = occupiedPositions[THREED_TO_ONED(coordX,coordY,coordZ)];													\
			for(auto nbDC: nearbyDCs){																							\
				if (nbDC<0){																									\
					nbDC=-nbDC;/*Only changes our iterator, not the vector element*/											\
					dendx=dCellList[nbDC].get_dest_x(); dendy=dCellList[nbDC].get_dest_y(); dendz=dCellList[nbDC].get_dest_z();	\
				}																												\
				else{																											\
					dendx=dCellList[nbDC].get_x(); dendy=dCellList[nbDC].get_y(); dendz=dCellList[nbDC].get_z();				\
				}																												\
				if( SQMAGNITUDE(x-dendx,y-dendy,z-dendz) <= contactRadius*contactRadius) { dCellNum=nbDC; inContact=1; break;}	\
			}																													\
		}

	//DC discrete grid
		#define REGENERATE_CELL_POSITIONS_AND_ANTIGEN(newTime,numWavesToGen){																									\
			dCellsPresent=0; for(uint wav=0; wav<numWaves; wav++) {dCellsPresentPerWave[wav]=0; /*nextArrivals[wav]=waveTimeSteps[wav];*/}										\
			for(uint mdci=1; mdci<=numDCells*numWavesToGen; mdci++){																											\
				/*Set the number of cognate antigen that this DC has*/																											\
				dCellList[mdci].set_num_cog_antigen(waveTimeSteps[waveNumber], cogAgOnArrival, cognateAgPrecision, cognateAgProbabilityTable);									\
																																												\
				/*Find valid coordinates to place this DC*/																														\
				posFailures=0;																																					\
				/*Keep regenerating coordinates until they are within the sphere and not in contact with another Dendrite*/														\
				while(1==1){ /*More efficient than the better practice of while(inContact==1), because of the need to continue if the random coordinates generated are bad.*/	\
					GENERATE_COORDS; /*Gets random values of x, y and z between -radius and +radius (coordinates from a cube of side = diameter)*/								\
					if(OUTSIDE_SPHERE(x,y,z)) continue;																															\
					inContact=0; CHECK_CONTACT_WITH_DENDRITES_DC(x,y,z,inContact); /*Sets inContact=1 if close to a DC*/														\
					if( (posFailures++)>POSITION_OOB_TOLERANCE ){cerr << "ERROR: Too many attempts to place a DC onto the grid without contacting another. Check parameter choices." << endl; return 1;}\
					else if(inContact==0) break;																																\
				}																																								\
																																												\
				/*If the coordinates are valid, set the DC's position and mark nearby sites on the discrete grid.*/																\
				/*Get destination position*/																																	\
				dCellList[mdci].set_destination(x,y,z);																															\
				/*Get source position*/																																			\
				theta=acos(genrand_uniform_pos(engine)); phi=3.141592654*genrand_uniform_pos(engine);/*Random theta between 0 and pi, phi between 0 and pi -> a hemisphere*/	\
				sourceX=radius*sin(theta)*cos(phi); sourceY=radius*sin(theta)*sin(phi); sourceZ=radius*cos(theta);																\
				dCellList[mdci].set_source(sourceX,sourceY,sourceZ); /*Random position on the surface of the hemisphere*/														\
				dCellList[mdci].set_position(sourceX,sourceY,sourceZ);																											\
				/*Calculate the DC's velocity between these points*/																											\
				vmag=MAGNITUDE(x-sourceX,y-sourceY,z-sourceZ)/dCellVelocity;																									\
				dCellList[mdci].set_velocity((x-sourceX)/vmag,(y-sourceY)/vmag,(z-sourceZ)/vmag); /*Velocity towards this random destination*/									\
				uint wav=int(mdci/numDCells);																																	\
				if(newTime>waveTimeSteps[wav] && timeStepsBetweenDCArrival==0 && dCellList[mdci].get_probActivation()>0){														\
					dCellList[mdci].set_entry_time(waveTimeSteps[waveNumber]); dCellList[mdci].set_timeMovementUpdated(waveTimeSteps[waveNumber]);	 							\
					PLACE_DC_PATH_ON_DISCRETE_GRID(mdci,sourceX,sourceY,sourceZ,x,y,z, waveTimeSteps[waveNumber]);																\
					dCellsPresent++; dCellsPresentPerWave[wav]++;																												\
				}																																								\
			}																																									\
			/*Place T cells on the grid, ensuring they are away from the DCs*/																									\
			posFailures=0;																																						\
			for(auto iter2 = cellMovementOrder.begin(); iter2 != cellMovementOrder.end(); iter2++){																				\
				tCellNum = *iter2;																																				\
				while(1==1){ /*More efficient than the better practice of while(inContact==1), because of the need to continue if the random coordinates generated are bad.*/	\
					GENERATE_COORDS; /*Gets random values of x, y and z between -radius and +radius (coordinates from a cube of side = diameter)*/								\
					if(OUTSIDE_SPHERE(x,y,z)) continue;																															\
					inContact=0; CHECK_CONTACT_WITH_DENDRITES_T(x,y,z,inContact); /*Sets inContact=1 if close to a DC*/															\
					if( (posFailures++)>POSITION_OOB_TOLERANCE ){cerr << "ERROR: Too many attempts to place a T-cell onto the grid without contacting a DC. Check parameter choices." << endl; return 1;}\
					else if(inContact==0) break;																																\
				}																																								\
																																												\
				/*If we have valid coordinates, set them*/																														\
				tCellList[tCellNum].set_position(x, y, z); tCellInitialX[tCellNum]=x; tCellInitialY[tCellNum]=y; tCellInitialZ[tCellNum]=z;										\
				freePathRemaining[tCellNum]=0;																																	\
			}																																									\
		}

		#define PLACE_DC_ON_DISCRETE_GRID_NO_DUPLCT(cx, cy, cz, dcnum) {				\
			for(int p = -1; p<=1; p++){ /*Adjacent cells in x*/							\
				if(cx+p >= numPositions) {break;}										\
				else if(cx+p < 0) {continue;}											\
																						\
				for(int q = -1; q<=1; q++){ /*Adjacent cells in y*/						\
					if(cy+q >= numPositions) {break;}									\
					else if(cy+q < 0) {continue;}										\
																						\
						for(int r = -1; r<=1; r++){ /*Adjacent cells in z*/				\
						if(cz+r >= numPositions) {break;}								\
						else if(cz+r < 0) {continue;}									\
						vecIt = &occupiedPositions[THREED_TO_ONED(cx+p,cy+q,cz+r)];		\
						if(POSITION_IN_VECTOR((*vecIt),dcnum)==(*vecIt).size())			\
							(*vecIt).push_back(dcnum);									\
					}																	\
				}																		\
			}																			\
		}
		#define REMOVE_DC_FROM_DISCRETE_GRID_NO_DUPLCT(cx, cy, cz, dcnum) {			\
			for(int p = -1; p<=1; p++){ /*Adjacent cells in x*/						\
				if(cx+p >= numPositions) break;										\
				else if(cx+p < 0) continue;											\
																					\
				for(int q = -1; q<=1; q++){ /*Adjacent cells in y*/					\
					if(cy+q >= numPositions) break;									\
					else if(cy+q < 0) continue;										\
																					\
						for(int r = -1; r<=1; r++){ /*Adjacent cells in z*/			\
						if(cz+r >= numPositions) break;								\
						else if(cz+r < 0) continue;									\
						vecIt = &occupiedPositions[THREED_TO_ONED(cx+p,cy+q,cz+r)];	\
						if(															\
							(elementPosition=POSITION_IN_VECTOR((*vecIt), dcnum)) 	\
								!= (*vecIt).size() 									\
						){															\
							(*vecIt).erase( 										\
								(*vecIt).begin()+elementPosition					\
							);														\
						}															\
					}																\
				}																	\
			}																		\
		}
		#define PLACE_DC_PATH_ON_DISCRETE_GRID(dcnum, sx,sy,sz, tarx,tary,tarz, entryTime){			\
			/*Find source & target coordinates, */ 														\
			dx=(tarx-sx); dy=(tary-sy); dz=(tarz-sz);												\
			dcoordX=DISCRETISE(tarx)-DISCRETISE(sx); dcoordY=DISCRETISE(tary)-DISCRETISE(sy); 		\
			dcoordZ=DISCRETISE(tarz)-DISCRETISE(sz);													\
			coordX=DISCRETISE(sx); coordY=DISCRETISE(sy); coordZ=DISCRETISE(sz);					\
																										\
			/*find time between each coord change in each direction*/									\
			timeTaken=MAGNITUDE(dx,dy,dz)/(dCellVelocity*timeStep);										\
			timePerCoordX=timeTaken/abs(dcoordX); timePerCoordY=timeTaken/abs(dcoordY);					\
			timePerCoordZ=timeTaken/abs(dcoordZ);														\
			vector<double> coordSwitchTimes;															\
			for(auto dq: {dcoordX, dcoordY, dcoordZ}){													\
				int mdq=(dq>0 ? dq : -dq);																\
				for(int index=1; index<=mdq; index++){													\
					coordSwitchTimes.push_back(entryTime+index*timeTaken/mdq);							\
				}																						\
			}																							\
			/*Sort the list of coord change times so that we can iterate through them*/					\
			sort(coordSwitchTimes.begin(), coordSwitchTimes.end());										\
																										\
			/*Remove duplicate entries*/																\
			for(uint i=1; i<coordSwitchTimes.size(); i++){												\
				if(coordSwitchTimes[i] - coordSwitchTimes[i-1]<1E-4){									\
					coordSwitchTimes.erase(coordSwitchTimes.begin()+i);									\
					i--;																				\
				}																						\
			}																							\
																										\
			/*Save the vector we constructed to the DC's memory*/										\
			dCellList[dcnum].set_coord_switch_times(coordSwitchTimes);									\
																										\
			/*Mark all sites with the time the DC will leave them*/										\
			for(auto it = coordSwitchTimes.begin(); it != coordSwitchTimes.end(); ++it){				\
				auto &cst = *it;																		\
				PLACE_DC_ON_DISCRETE_GRID_NO_DUPLCT(coordX,coordY,coordZ,-(dcnum));/*Negative to define a moving DC*/\
				if(abs(remainder(cst-entryTime,timePerCoordX))<1E-6){	/*Faster than fmod*/			\
					if(dcoordX>0) coordX++;																\
					else coordX--;																		\
				}																						\
				if(abs(remainder(cst-entryTime,timePerCoordY))<1E-6){									\
					if(dcoordY>0) coordY++;																\
					else coordY--;																		\
				}																						\
				if(abs(remainder(cst-entryTime,timePerCoordZ))<1E-6){									\
					if(dcoordZ>0) coordZ++;																\
					else coordZ--;																		\
				}																						\
			}																							\
			PLACE_DC_ON_DISCRETE_GRID_NO_DUPLCT(coordX,coordY,coordZ,-(dcnum)); /*Mark final site with -ve value*/	\
			assert(coordX==DISCRETISE(tarx) && coordY==DISCRETISE(tary) && coordZ==DISCRETISE(tarz));		\
		}																								
		#define UPDATE_POSITION_OF_MOVING_DC(DCnum){																						\
			canActivate=!dCellList[DCnum].update_num_cog_antigen(t, timeStep, antigenDecayRate, cognateAgPrecision, cognateAgProbabilityTable);		\
			sourceT	= dCellList[DCnum].get_entry_time(); 																					\
			sourceX=dCellList[DCnum].get_source_x(); sourceY=dCellList[DCnum].get_source_y(); sourceZ=dCellList[DCnum].get_source_z();		\
			velocity= dCellList[DCnum].get_vel();																							\
			dendx=sourceX+velocity[0]*(t-sourceT)*timeStep; dendy=sourceY+velocity[1]*(t-sourceT)*timeStep; 								\
			dendz=sourceZ+velocity[2]*(t-sourceT)*timeStep;																					\
			dCellList[DCnum].set_position(dendx,dendy,dendz);																				\
																																			\
			/*Remove traces of this DC from the path behind it*/																			\
			tarx=dCellList[DCnum].get_dest_x(); tary=dCellList[DCnum].get_dest_y(); tarz=dCellList[DCnum].get_dest_z();						\
																																			\
			/*Find source & target coordinates, */ 																							\
			dx=(tarx-sourceX); dy=(tary-sourceY); dz=(tarz-sourceZ);																		\
			dcoordX=DISCRETISE(tarx)-DISCRETISE(sourceX); dcoordY=DISCRETISE(tary)-DISCRETISE(sourceY); 									\
			dcoordZ=DISCRETISE(tarz)-DISCRETISE(sourceZ);																					\
			coordX=DISCRETISE(sourceX); coordY=DISCRETISE(sourceY); coordZ=DISCRETISE(sourceZ);												\
																																			\
			/*find time between each coord change in each direction*/																		\
			timeTaken=MAGNITUDE(dx,dy,dz)/(dCellVelocity*timeStep);																			\
			/*contactRegionClearanceTime=2*double(contactRadius)/(dCellVelocity*timeStep);	Defined in main*/								\
			timePerCoordX=timeTaken/abs(dcoordX); timePerCoordY=timeTaken/abs(dcoordY);														\
			timePerCoordZ=timeTaken/abs(dcoordZ);																							\
																																			\
			/*Get time last updated*/																										\
			entryTime=dCellList[DCnum].get_entry_time();																					\
			timeLastUpdated=dCellList[DCnum].get_timeMovementUpdated(); 																	\
			discreteGridUpdatedThisTimestep=0; 																								\
			stillMoving= (int(t-entryTime)>timeTaken) ? 0 : canActivate;/*Decide whether to keep sites DC will visit in future*/			\
			vector<double> coordSwitchTimes=dCellList[DCnum].get_coord_switch_times();														\
																																			\
			/*Remove all sites the DC visited after the last time we did this and before the current time*/									\
			cst_it = coordSwitchTimes.begin();																								\
			for(; cst_it != coordSwitchTimes.end(); ++cst_it){																				\
				auto &cst = *cst_it;																										\
				if((t-cst < contactRegionClearanceTime && stillMoving) || t==timeLastUpdated){												\
					break;/*Don't remove current or future sites*/																			\
				}																															\
				if(timeLastUpdated >= contactRegionClearanceTime + cst) continue; /*If we've already removed this site in a previous update*/\
				else if(discreteGridUpdatedThisTimestep==0){																				\
					if(cst_it!=coordSwitchTimes.begin()){																					\
						coordX = DISCRETISE(sourceX)+(*(cst_it-1)-entryTime)*dcoordX/timeTaken + (dcoordX>0 ? TIME_TOLERANCE : 0.999);/*Not using timePerCoordX due to abs*/\
						coordY = DISCRETISE(sourceY)+(*(cst_it-1)-entryTime)*dcoordY/timeTaken + (dcoordY>0 ? TIME_TOLERANCE : 0.999);/*This final factor is to correct for integer conversion*/\
						coordZ = DISCRETISE(sourceZ)+(*(cst_it-1)-entryTime)*dcoordZ/timeTaken + (dcoordZ>0 ? TIME_TOLERANCE : 0.999);/*when change in coordinate is negative, e.g. 62.3 -> 63*/\
						discreteGridUpdatedThisTimestep=1;																					\
					}																														\
				}																															\
				vecIt=&occupiedPositions[THREED_TO_ONED(coordX,coordY,coordZ)];																\
				REMOVE_DC_FROM_DISCRETE_GRID_NO_DUPLCT(coordX,coordY,coordZ,-(DCnum));														\
				if(abs(remainder(cst-entryTime,timePerCoordX))<1E-6){	/*Faster than fmod*/												\
					if(dcoordX>0) coordX++;																									\
					else coordX--;																											\
				}																															\
				if(abs(remainder(cst-entryTime,timePerCoordY))<1E-6){																		\
					if(dcoordY>0) coordY++;																									\
					else coordY--;																											\
				}																															\
				if(abs(remainder(cst-entryTime,timePerCoordZ))<1E-6){																		\
					if(dcoordZ>0) coordZ++;																									\
					else coordZ--;																											\
				}																															\
			}																																\
			if(discreteGridUpdatedThisTimestep==1) dCellList[DCnum].set_timeMovementUpdated(t/**(cst_it-1)*/);/*If we exited the loop, then the 	\
			iterator increased and so we need -1. If we broke the loop in the if statement, then we DIDN'T update on the last value of the 	\
			iterator, so still need -1.*/																									\
																																			\
			/*If the DC has reached its destination, place it onto the grid as a non-moving DC*/											\
			if( int(t - entryTime) > timeTaken || !canActivate ){/*t and entryTime are unit!*/												\
				coordX = DISCRETISE(tarx); coordY = DISCRETISE(tary); coordZ = DISCRETISE(tarz); 											\
				REMOVE_DC_FROM_DISCRETE_GRID_NO_DUPLCT(coordX,coordY,coordZ,-(DCnum)); 														\
				if(canActivate){																											\
					dCellList[DCnum].set_position(dCellList[DCnum].get_dest_x(),dCellList[DCnum].get_dest_y(),dCellList[DCnum].get_dest_z());	\
					PLACE_DC_ON_DISCRETE_GRID(coordX,coordY,coordZ,DCnum); dCellList[DCnum].set_timeMovementUpdated(numTimeSteps);			\
				}																															\
			}																																\
		}	
#endif
	//__LINEAR_FUNCTIONS_INCLUDED__

